/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api;

import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.ProductCategory;

public class PlanPhaseSpecifier {
    private final PhaseType phaseType;
    private final String productName;
    private final ProductCategory productCategory;
    private final BillingPeriod billingPeriod;
    private final String priceListName;

    public PlanPhaseSpecifier(String productName, ProductCategory productCategory, BillingPeriod billingPeriod, String priceListName, PhaseType phaseType) {
        this.phaseType = phaseType;
        this.productName = productName;
        this.productCategory = productCategory;
        this.billingPeriod = billingPeriod;
        this.priceListName = priceListName;
    }

    public String getProductName() {
        return this.productName;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public String getPriceListName() {
        return this.priceListName;
    }

    public PhaseType getPhaseType() {
        return this.phaseType;
    }

    public PlanSpecifier toPlanSpecifier() {
        return new PlanSpecifier(this.productName, this.productCategory, this.billingPeriod, this.priceListName);
    }
}

