/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.user;

import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.AccountTestSuiteNoDB;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultAccountEmail;
import org.killbill.billing.account.api.user.DefaultAccountUserApi;
import org.killbill.billing.account.dao.AccountDao;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.account.dao.MockAccountDao;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.CallContextFactory;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDefaultAccountUserApiWithMocks
extends AccountTestSuiteNoDB {
    private final CallContextFactory factory = (CallContextFactory)Mockito.mock(CallContextFactory.class);
    private final InternalCallContextFactory internalFactory = (InternalCallContextFactory)Mockito.mock(InternalCallContextFactory.class);
    private final CallContext callContext = (CallContext)Mockito.mock(CallContext.class);
    private final InternalTenantContext tenantContext = (InternalTenantContext)Mockito.mock(InternalTenantContext.class);
    private AccountDao accountDao;
    private DefaultAccountUserApi accountUserApi;

    @BeforeMethod(groups={"fast"})
    public void setUp() throws Exception {
        this.accountDao = new MockAccountDao((PersistentBus)Mockito.mock(PersistentBus.class), (Clock)this.clock);
        this.accountUserApi = new DefaultAccountUserApi(this.immutableAccountInternalApi, this.accountDao, this.nonEntityDao, this.controllerDispatcher, this.internalFactory);
    }

    @Test(groups={"fast"}, description="Test Account create API")
    public void testCreateAccount() throws Exception {
        UUID id = UUID.randomUUID();
        String externalKey = UUID.randomUUID().toString();
        String email = UUID.randomUUID().toString();
        String name = UUID.randomUUID().toString();
        Integer firstNameLength = Integer.MAX_VALUE;
        Currency currency = Currency.BRL;
        Integer billCycleDay = Integer.MAX_VALUE;
        UUID paymentMethodId = UUID.randomUUID();
        DateTime referenceTime = this.clock.getUTCNow();
        DateTimeZone timeZone = DateTimeZone.UTC;
        String locale = UUID.randomUUID().toString();
        String address1 = UUID.randomUUID().toString();
        String address2 = UUID.randomUUID().toString();
        String companyName = UUID.randomUUID().toString();
        String city = UUID.randomUUID().toString();
        String stateOrProvince = UUID.randomUUID().toString();
        String country = UUID.randomUUID().toString();
        String postalCode = UUID.randomUUID().toString();
        String phone = UUID.randomUUID().toString();
        String notes = UUID.randomUUID().toString();
        Boolean isMigrated = true;
        DefaultAccount data = new DefaultAccount(id, externalKey, email, name, firstNameLength, currency, null, Boolean.valueOf(false), billCycleDay, paymentMethodId, referenceTime, timeZone, locale, address1, address2, companyName, city, stateOrProvince, country, postalCode, phone, notes, isMigrated);
        this.accountUserApi.createAccount((AccountData)data, this.callContext);
        AccountModelDao account = this.accountDao.getAccountByKey(externalKey, this.tenantContext);
        Assert.assertEquals((String)account.getExternalKey(), (String)externalKey);
        Assert.assertEquals((String)account.getEmail(), (String)email);
        Assert.assertEquals((String)account.getName(), (String)name);
        Assert.assertEquals((Object)account.getFirstNameLength(), (Object)firstNameLength);
        Assert.assertEquals((Object)account.getCurrency(), (Object)currency);
        Assert.assertEquals((Object)account.getBillingCycleDayLocal(), (Object)billCycleDay);
        Assert.assertEquals((Object)account.getPaymentMethodId(), (Object)paymentMethodId);
        Assert.assertEquals((Object)account.getTimeZone(), (Object)timeZone);
        Assert.assertEquals((String)account.getLocale(), (String)locale);
        Assert.assertEquals((String)account.getAddress1(), (String)address1);
        Assert.assertEquals((String)account.getAddress2(), (String)address2);
        Assert.assertEquals((String)account.getCompanyName(), (String)companyName);
        Assert.assertEquals((String)account.getCity(), (String)city);
        Assert.assertEquals((String)account.getStateOrProvince(), (String)stateOrProvince);
        Assert.assertEquals((String)account.getCountry(), (String)country);
        Assert.assertEquals((String)account.getPostalCode(), (String)postalCode);
        Assert.assertEquals((String)account.getPhone(), (String)phone);
        Assert.assertEquals((Object)account.getMigrated(), (Object)isMigrated);
    }

    @Test(groups={"fast"}, description="Test ability to add email to Account")
    public void testAddEmail() throws Exception {
        UUID accountId = UUID.randomUUID();
        Assert.assertEquals((int)this.accountDao.getEmailsByAccountId(accountId, this.tenantContext).size(), (int)0);
        String emailAddress1 = UUID.randomUUID().toString();
        DefaultAccountEmail email1 = new DefaultAccountEmail(accountId, emailAddress1);
        this.accountUserApi.addEmail(accountId, (AccountEmail)email1, this.callContext);
        Assert.assertEquals((int)this.accountDao.getEmailsByAccountId(accountId, this.tenantContext).size(), (int)1);
        String emailAddress2 = UUID.randomUUID().toString();
        DefaultAccountEmail email2 = new DefaultAccountEmail(accountId, emailAddress2);
        this.accountUserApi.addEmail(accountId, (AccountEmail)email2, this.callContext);
        Assert.assertEquals((int)this.accountDao.getEmailsByAccountId(accountId, this.tenantContext).size(), (int)2);
        this.accountUserApi.removeEmail(accountId, (AccountEmail)email1, this.callContext);
        Assert.assertEquals((int)this.accountDao.getEmailsByAccountId(accountId, this.tenantContext).size(), (int)1);
    }
}

