/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api;

import java.util.UUID;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.AccountTestSuiteNoDB;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultMutableAccountData;
import org.killbill.billing.catalog.api.Currency;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultAccount
extends AccountTestSuiteNoDB {
    @Test(groups={"fast"}, description="Test if Account constructor can accept null values")
    public void testConstructorAcceptsNullValues() throws Exception {
        AccountData accountData = this.getNullAccountData();
        DefaultAccount account = new DefaultAccount(UUID.randomUUID(), accountData);
        Assert.assertNull((Object)account.getExternalKey());
        Assert.assertNull((Object)account.getEmail());
        Assert.assertNull((Object)account.getName());
        Assert.assertNull((Object)account.getFirstNameLength());
        Assert.assertNull((Object)account.getCurrency());
        Assert.assertEquals((Object)account.getBillCycleDayLocal(), (Object)0);
        Assert.assertNull((Object)account.getPaymentMethodId());
        Assert.assertNull((Object)account.getTimeZone());
        Assert.assertNull((Object)account.getLocale());
        Assert.assertNull((Object)account.getAddress1());
        Assert.assertNull((Object)account.getAddress2());
        Assert.assertNull((Object)account.getCompanyName());
        Assert.assertNull((Object)account.getCity());
        Assert.assertNull((Object)account.getStateOrProvince());
        Assert.assertNull((Object)account.getCountry());
        Assert.assertNull((Object)account.getPostalCode());
        Assert.assertNull((Object)account.getPhone());
        Assert.assertNull((Object)account.isMigrated());
    }

    @Test(groups={"fast"}, description="Test mergeWithDelegate Account api")
    public void testMergeWithDelegate() throws Exception {
        AccountData accountData = this.getNullAccountData();
        DefaultAccount account = new DefaultAccount(UUID.randomUUID(), accountData);
        AccountData accountDataUpdates1 = this.getAccountData(account.getBillCycleDayLocal(), account.getCurrency(), account.getExternalKey());
        DefaultAccount accountUpdates1 = new DefaultAccount(UUID.randomUUID(), accountDataUpdates1);
        Account updatedAccount1 = accountUpdates1.mergeWithDelegate((Account)account);
        this.checkAccountEquals(updatedAccount1, (Account)accountUpdates1);
        AccountData accountDataUpdates2 = (AccountData)Mockito.mock(AccountData.class);
        Mockito.when((Object)accountDataUpdates2.getEmail()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)accountDataUpdates2.getName()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)accountDataUpdates2.getFirstNameLength()).thenReturn((Object)12);
        DefaultAccount accountUpdates2 = new DefaultAccount(UUID.randomUUID(), accountDataUpdates2);
        Account updatedAccount2 = accountUpdates2.mergeWithDelegate(updatedAccount1);
        Assert.assertEquals((String)updatedAccount2.getEmail(), (String)accountUpdates2.getEmail());
        Assert.assertEquals((String)updatedAccount2.getName(), (String)accountUpdates2.getName());
        Assert.assertEquals((Object)updatedAccount2.getFirstNameLength(), (Object)updatedAccount2.getFirstNameLength());
        Assert.assertEquals((String)updatedAccount2.getExternalKey(), (String)updatedAccount1.getExternalKey());
        Assert.assertEquals((Object)updatedAccount2.getCurrency(), (Object)updatedAccount1.getCurrency());
        Assert.assertEquals((Object)updatedAccount2.getBillCycleDayLocal(), (Object)updatedAccount1.getBillCycleDayLocal());
        Assert.assertEquals((Object)updatedAccount2.getPaymentMethodId(), (Object)updatedAccount1.getPaymentMethodId());
        Assert.assertEquals((Object)updatedAccount2.getTimeZone(), (Object)updatedAccount1.getTimeZone());
        Assert.assertEquals((String)updatedAccount2.getLocale(), (String)updatedAccount1.getLocale());
        Assert.assertEquals((String)updatedAccount2.getAddress1(), (String)updatedAccount1.getAddress1());
        Assert.assertEquals((String)updatedAccount2.getAddress2(), (String)updatedAccount1.getAddress2());
        Assert.assertEquals((String)updatedAccount2.getCompanyName(), (String)updatedAccount1.getCompanyName());
        Assert.assertEquals((String)updatedAccount2.getCity(), (String)updatedAccount1.getCity());
        Assert.assertEquals((String)updatedAccount2.getStateOrProvince(), (String)updatedAccount1.getStateOrProvince());
        Assert.assertEquals((String)updatedAccount2.getCountry(), (String)updatedAccount1.getCountry());
        Assert.assertEquals((String)updatedAccount2.getPostalCode(), (String)updatedAccount1.getPostalCode());
        Assert.assertEquals((String)updatedAccount2.getPhone(), (String)updatedAccount1.getPhone());
        Assert.assertEquals((Object)updatedAccount2.isMigrated(), (Object)updatedAccount1.isMigrated());
    }

    @Test(groups={"fast"}, description="Test Account BCD merge")
    public void testBCDMerges() throws Exception {
        UUID accountId = UUID.randomUUID();
        Currency currency = Currency.BRL;
        String externalKey = UUID.randomUUID().toString();
        AccountData accountDataWithNullBCD = this.getAccountData(null, currency, externalKey);
        DefaultAccount accountWithNullBCD = new DefaultAccount(accountId, accountDataWithNullBCD);
        Assert.assertEquals((Object)accountWithNullBCD.getBillCycleDayLocal(), (Object)0);
        DefaultMutableAccountData accountDataWithZeroBCD = new DefaultMutableAccountData(accountDataWithNullBCD);
        accountDataWithZeroBCD.setBillCycleDayLocal(0);
        DefaultAccount accountWithZeroBCD = new DefaultAccount(accountId, (AccountData)accountDataWithZeroBCD);
        Assert.assertEquals((Object)accountWithNullBCD.mergeWithDelegate((Account)accountWithZeroBCD).getBillCycleDayLocal(), (Object)0);
        DefaultMutableAccountData accountDataWithRealBCD = new DefaultMutableAccountData(accountDataWithNullBCD);
        accountDataWithRealBCD.setBillCycleDayLocal(12);
        DefaultAccount accountWithRealBCD = new DefaultAccount(accountId, (AccountData)accountDataWithRealBCD);
        Assert.assertEquals((Object)accountWithNullBCD.mergeWithDelegate((Account)accountWithRealBCD).getBillCycleDayLocal(), (Object)12);
        DefaultMutableAccountData accountDataWithAnotherRealBCD = new DefaultMutableAccountData(accountDataWithNullBCD);
        accountDataWithAnotherRealBCD.setBillCycleDayLocal(20);
        DefaultAccount accountWithAnotherBCD = new DefaultAccount(accountId, (AccountData)accountDataWithAnotherRealBCD);
        Assert.assertEquals((Object)accountWithAnotherBCD.mergeWithDelegate((Account)accountWithAnotherBCD).getBillCycleDayLocal(), (Object)20);
        try {
            Assert.assertEquals((Object)accountWithAnotherBCD.mergeWithDelegate((Account)accountWithRealBCD).getBillCycleDayLocal(), (Object)20);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    private void checkAccountEquals(Account finalAccount, Account delegateAccount) {
        Assert.assertEquals((String)finalAccount.getExternalKey(), (String)delegateAccount.getExternalKey());
        Assert.assertEquals((String)finalAccount.getEmail(), (String)delegateAccount.getEmail());
        Assert.assertEquals((String)finalAccount.getName(), (String)delegateAccount.getName());
        Assert.assertEquals((Object)finalAccount.getFirstNameLength(), (Object)delegateAccount.getFirstNameLength());
        Assert.assertEquals((Object)finalAccount.getCurrency(), (Object)delegateAccount.getCurrency());
        Assert.assertEquals((Object)finalAccount.getBillCycleDayLocal(), (Object)delegateAccount.getBillCycleDayLocal());
        Assert.assertEquals((Object)finalAccount.getPaymentMethodId(), (Object)delegateAccount.getPaymentMethodId());
        Assert.assertEquals((Object)finalAccount.getTimeZone(), (Object)delegateAccount.getTimeZone());
        Assert.assertEquals((String)finalAccount.getLocale(), (String)delegateAccount.getLocale());
        Assert.assertEquals((String)finalAccount.getAddress1(), (String)delegateAccount.getAddress1());
        Assert.assertEquals((String)finalAccount.getAddress2(), (String)delegateAccount.getAddress2());
        Assert.assertEquals((String)finalAccount.getCompanyName(), (String)delegateAccount.getCompanyName());
        Assert.assertEquals((String)finalAccount.getCity(), (String)delegateAccount.getCity());
        Assert.assertEquals((String)finalAccount.getStateOrProvince(), (String)delegateAccount.getStateOrProvince());
        Assert.assertEquals((String)finalAccount.getCountry(), (String)delegateAccount.getCountry());
        Assert.assertEquals((String)finalAccount.getPostalCode(), (String)delegateAccount.getPostalCode());
        Assert.assertEquals((String)finalAccount.getPhone(), (String)delegateAccount.getPhone());
        Assert.assertEquals((String)finalAccount.getNotes(), (String)delegateAccount.getNotes());
        Assert.assertEquals((Object)finalAccount.isMigrated(), (Object)delegateAccount.isMigrated());
    }

    private AccountData getAccountData(Integer bcd, Currency currency, String externalKey) {
        AccountData secondAccountData = (AccountData)Mockito.mock(AccountData.class);
        Mockito.when((Object)secondAccountData.getExternalKey()).thenReturn((Object)externalKey);
        Mockito.when((Object)secondAccountData.getEmail()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.getName()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.getFirstNameLength()).thenReturn((Object)Integer.MAX_VALUE);
        Mockito.when((Object)secondAccountData.getCurrency()).thenReturn((Object)currency);
        Mockito.when((Object)secondAccountData.getBillCycleDayLocal()).thenReturn((Object)bcd);
        Mockito.when((Object)secondAccountData.getPaymentMethodId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)secondAccountData.getTimeZone()).thenReturn((Object)DateTimeZone.forID((String)"EST"));
        Mockito.when((Object)secondAccountData.getLocale()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.getAddress1()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.getAddress2()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.getCompanyName()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.getCity()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.getStateOrProvince()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.getCountry()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.getPostalCode()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.getPhone()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)secondAccountData.isMigrated()).thenReturn((Object)false);
        return secondAccountData;
    }

    private AccountData getNullAccountData() {
        return (AccountData)Mockito.mock(AccountData.class, (Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return null;
            }
        });
    }
}

