/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account;

import java.util.Locale;
import java.util.UUID;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.DefaultMutableAccountData;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.catalog.api.Currency;
import org.testng.Assert;

public abstract class AccountTestUtils {
    public static void checkAccountsEqual(AccountData retrievedAccount, AccountData account) {
        UUID fakeId = UUID.randomUUID();
        AccountTestUtils.checkAccountsEqual(new AccountModelDao(fakeId, retrievedAccount), new AccountModelDao(fakeId, account));
    }

    public static void checkAccountsEqual(AccountModelDao retrievedAccount, AccountModelDao account) {
        if (retrievedAccount == null || account == null) {
            Assert.assertNull((Object)retrievedAccount);
            Assert.assertNull((Object)account);
            return;
        }
        Assert.assertEquals((Object)retrievedAccount.getId(), (Object)account.getId());
        Assert.assertEquals((String)retrievedAccount.getExternalKey(), (String)account.getExternalKey());
        Assert.assertEquals((String)retrievedAccount.getEmail(), (String)account.getEmail());
        Assert.assertEquals((String)retrievedAccount.getName(), (String)account.getName());
        Assert.assertEquals((Object)retrievedAccount.getFirstNameLength(), (Object)account.getFirstNameLength());
        Assert.assertEquals((Object)retrievedAccount.getCurrency(), (Object)account.getCurrency());
        Assert.assertEquals((Object)retrievedAccount.getBillingCycleDayLocal(), (Object)account.getBillingCycleDayLocal());
        Assert.assertEquals((Object)retrievedAccount.getPaymentMethodId(), (Object)account.getPaymentMethodId());
        Assert.assertEquals((Object)retrievedAccount.getTimeZone(), (Object)account.getTimeZone());
        Assert.assertEquals((String)retrievedAccount.getLocale(), (String)account.getLocale());
        Assert.assertEquals((String)retrievedAccount.getAddress1(), (String)account.getAddress1());
        Assert.assertEquals((String)retrievedAccount.getAddress2(), (String)account.getAddress2());
        Assert.assertEquals((String)retrievedAccount.getCompanyName(), (String)account.getCompanyName());
        Assert.assertEquals((String)retrievedAccount.getCity(), (String)account.getCity());
        Assert.assertEquals((String)retrievedAccount.getStateOrProvince(), (String)account.getStateOrProvince());
        Assert.assertEquals((String)retrievedAccount.getCountry(), (String)account.getCountry());
        Assert.assertEquals((String)retrievedAccount.getPostalCode(), (String)account.getPostalCode());
        Assert.assertEquals((String)retrievedAccount.getPhone(), (String)account.getPhone());
        Assert.assertEquals((Object)retrievedAccount.getMigrated(), (Object)account.getMigrated());
    }

    public static AccountModelDao createTestAccount() {
        return AccountTestUtils.createTestAccount(31, UUID.randomUUID().toString().substring(0, 4));
    }

    public static AccountModelDao createTestAccount(String phone) {
        return AccountTestUtils.createTestAccount(31, phone);
    }

    public static AccountModelDao createTestAccount(int billCycleDay) {
        return AccountTestUtils.createTestAccount(billCycleDay, UUID.randomUUID().toString().substring(0, 4));
    }

    private static AccountModelDao createTestAccount(int billCycleDayLocal, String phone) {
        MutableAccountData accountData = AccountTestUtils.createAccountData(billCycleDayLocal, phone);
        return new AccountModelDao(UUID.randomUUID(), (AccountData)accountData);
    }

    public static MutableAccountData createAccountData() {
        return AccountTestUtils.createAccountData(31, UUID.randomUUID().toString().substring(0, 4));
    }

    private static MutableAccountData createAccountData(int billCycleDayLocal, String phone) {
        String externalKey = UUID.randomUUID().toString();
        String email = UUID.randomUUID().toString().substring(0, 4) + '@' + UUID.randomUUID().toString().substring(0, 4);
        String name = UUID.randomUUID().toString();
        String locale = Locale.GERMANY.toString();
        DateTimeZone timeZone = DateTimeZone.forID((String)"America/Los_Angeles");
        int firstNameLength = name.length();
        Currency currency = Currency.MXN;
        UUID paymentMethodId = UUID.randomUUID();
        String address1 = UUID.randomUUID().toString();
        String address2 = UUID.randomUUID().toString();
        String companyName = UUID.randomUUID().toString();
        String city = UUID.randomUUID().toString();
        String stateOrProvince = UUID.randomUUID().toString();
        String country = Locale.GERMANY.getCountry();
        String postalCode = UUID.randomUUID().toString().substring(0, 4);
        String notes = UUID.randomUUID().toString();
        return new DefaultMutableAccountData(externalKey, email, name, firstNameLength, currency, null, Boolean.valueOf(false), billCycleDayLocal, paymentMethodId, null, timeZone, locale, address1, address2, companyName, city, stateOrProvince, country, postalCode, phone, notes, false);
    }
}

