/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.user;

import java.util.ArrayList;
import java.util.UUID;
import org.killbill.billing.account.AccountTestSuiteNoDB;
import org.killbill.billing.account.api.DefaultChangedField;
import org.killbill.billing.account.api.user.DefaultAccountChangeEvent;
import org.killbill.billing.account.api.user.DefaultAccountCreationEvent;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEventJson
extends AccountTestSuiteNoDB {
    private final ObjectMapper mapper = new ObjectMapper();

    @Test(groups={"fast"}, description="Test Account event deserialization")
    public void testDefaultAccountChangeEvent() throws Exception {
        ArrayList<DefaultChangedField> changes = new ArrayList<DefaultChangedField>();
        changes.add(new DefaultChangedField("fieldXX", "valueX", "valueXXX", this.clock.getUTCNow()));
        changes.add(new DefaultChangedField("fieldYY", "valueY", "valueYYY", this.clock.getUTCNow()));
        DefaultAccountChangeEvent e = new DefaultAccountChangeEvent(changes, UUID.randomUUID(), Long.valueOf(1L), Long.valueOf(2L), null);
        String json = this.mapper.writeValueAsString((Object)e);
        Class<?> claz = Class.forName("org.killbill.billing.account.api.user.DefaultAccountChangeEvent");
        Object obj = this.mapper.readValue(json, claz);
        Assert.assertTrue((boolean)obj.equals(e));
    }

    @Test(groups={"fast"}, description="Test Account event serialization")
    public void testAccountCreationEvent() throws Exception {
        DefaultAccountCreationEvent.DefaultAccountData data = new DefaultAccountCreationEvent.DefaultAccountData("dsfdsf", "bobo", Integer.valueOf(3), "bobo@yahoo.com", Integer.valueOf(12), "USD", null, Boolean.valueOf(false), UUID.randomUUID(), "UTC", "US", "21 avenue", "", "Gling", "San Franciso", "CA", "94110", "USA", "4126789887", "notes", Boolean.valueOf(false), Boolean.valueOf(false));
        DefaultAccountCreationEvent e = new DefaultAccountCreationEvent(data, UUID.randomUUID(), Long.valueOf(1L), Long.valueOf(2L), null);
        String json = this.mapper.writeValueAsString((Object)e);
        DefaultAccountCreationEvent obj = (DefaultAccountCreationEvent)this.mapper.readValue(json, DefaultAccountCreationEvent.class);
        Assert.assertTrue((boolean)obj.equals((Object)e));
    }
}

