/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.dao;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.DefaultImmutableAccountData;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.account.api.user.DefaultAccountChangeEvent;
import org.killbill.billing.account.api.user.DefaultAccountCreationEvent;
import org.killbill.billing.account.dao.AccountDao;
import org.killbill.billing.account.dao.AccountEmailModelDao;
import org.killbill.billing.account.dao.AccountEmailSqlDao;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.account.dao.AccountSqlDao;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.entity.EntityPersistenceException;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.DefaultPagination;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationSqlDaoHelper;
import org.killbill.billing.util.entity.dao.EntityDaoBase;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.billing.util.entity.dao.TimeZoneAwareEntity;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccountDao
extends EntityDaoBase<AccountModelDao, Account, AccountApiException>
implements AccountDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultAccountDao.class);
    private final CacheController<Long, ImmutableAccountData> accountImmutableCacheController;
    private final PersistentBus eventBus;
    private final InternalCallContextFactory internalCallContextFactory;
    private final Clock clock;

    @Inject
    public DefaultAccountDao(IDBI dbi, PersistentBus eventBus, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, InternalCallContextFactory internalCallContextFactory, NonEntityDao nonEntityDao) {
        super(new EntitySqlDaoTransactionalJdbiWrapper(dbi, clock, cacheControllerDispatcher, nonEntityDao, internalCallContextFactory), AccountSqlDao.class);
        this.accountImmutableCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_IMMUTABLE);
        this.eventBus = eventBus;
        this.internalCallContextFactory = internalCallContextFactory;
        this.clock = clock;
    }

    public void create(AccountModelDao entity, InternalCallContext context) throws AccountApiException {
        AccountModelDao refreshedEntity = (AccountModelDao)((Object)this.transactionalSqlDao.execute(this.getCreateEntitySqlDaoTransactionWrapper(entity, context)));
        this.transactionalSqlDao.populateCaches((EntityModelDao)refreshedEntity);
        this.accountImmutableCacheController.putIfAbsent((Object)refreshedEntity.getRecordId(), (Object)new DefaultImmutableAccountData(refreshedEntity));
    }

    protected AccountApiException generateAlreadyExistsException(AccountModelDao account, InternalCallContext context) {
        return new AccountApiException(ErrorCode.ACCOUNT_ALREADY_EXISTS, new Object[]{account.getExternalKey()});
    }

    protected void postBusEventFromTransaction(AccountModelDao account, AccountModelDao savedAccount, ChangeType changeType, EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, InternalCallContext context) throws BillingExceptionBase {
        switch (changeType) {
            case INSERT: {
                break;
            }
            default: {
                return;
            }
        }
        Long recordId = savedAccount.getRecordId();
        InternalCallContext rehydratedContext = this.internalCallContextFactory.createInternalCallContext((TimeZoneAwareEntity)savedAccount, recordId, context);
        DefaultAccountCreationEvent creationEvent = new DefaultAccountCreationEvent(new DefaultAccountCreationEvent.DefaultAccountData(savedAccount), savedAccount.getId(), rehydratedContext.getAccountRecordId(), rehydratedContext.getTenantRecordId(), rehydratedContext.getUserToken());
        try {
            this.eventBus.postFromTransaction((BusEvent)creationEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
        }
        catch (PersistentBus.EventBusException e) {
            log.warn("Failed to post account creation event for accountId='{}'", (Object)savedAccount.getId(), (Object)e);
        }
    }

    @Override
    public AccountModelDao getAccountByKey(final String key, final InternalTenantContext context) {
        return (AccountModelDao)((Object)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<AccountModelDao>(){

            public AccountModelDao inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return ((AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class)).getAccountByKey(key, context);
            }
        }));
    }

    @Override
    public Pagination<AccountModelDao> searchAccounts(final String searchKey, Long offset, Long limit, final InternalTenantContext context) {
        boolean userIsFeelingLucky;
        boolean bl = userIsFeelingLucky = limit == 1L && offset == -1L;
        if (userIsFeelingLucky) {
            AccountModelDao accountModelDao = (AccountModelDao)((Object)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<AccountModelDao>(){

                public AccountModelDao inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                    return ((AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class)).luckySearch(searchKey, context);
                }
            }));
            return new DefaultPagination(Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(accountModelDao == null ? 0L : 1L), null, (Iterator)(accountModelDao == null ? ImmutableList.of().iterator() : ImmutableList.of((Object)((Object)accountModelDao)).iterator()));
        }
        return this.paginationHelper.getPagination(AccountSqlDao.class, (DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder)new DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder<AccountModelDao, Account, AccountSqlDao>(){

            public Long getCount(AccountSqlDao accountSqlDao, InternalTenantContext context) {
                return accountSqlDao.getSearchCount(searchKey, String.format("%%%s%%", searchKey), context);
            }

            public Iterator<AccountModelDao> build(AccountSqlDao accountSqlDao, Long offset, Long limit, DefaultPaginationSqlDaoHelper.Ordering ordering, InternalTenantContext context) {
                return accountSqlDao.search(searchKey, String.format("%%%s%%", searchKey), offset, limit, ordering.toString(), context);
            }
        }, offset, limit, context);
    }

    @Override
    public UUID getIdFromKey(final String externalKey, final InternalTenantContext context) throws AccountApiException {
        if (externalKey == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_CANNOT_MAP_NULL_KEY, new Object[]{""});
        }
        return (UUID)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<UUID>(){

            public UUID inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return ((AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class)).getIdFromKey(externalKey, context);
            }
        });
    }

    @Override
    public void update(final AccountModelDao specifiedAccount, final InternalCallContext context) throws AccountApiException {
        this.transactionalSqlDao.execute(AccountApiException.class, (EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws PersistentBus.EventBusException, AccountApiException {
                UUID accountId;
                AccountSqlDao transactional = (AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class);
                AccountModelDao currentAccount = (AccountModelDao)transactional.getById((accountId = specifiedAccount.getId()).toString(), (InternalTenantContext)context);
                if (currentAccount == null) {
                    throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{accountId});
                }
                transactional.update(specifiedAccount, context);
                DefaultAccountChangeEvent changeEvent = new DefaultAccountChangeEvent(accountId, currentAccount, specifiedAccount, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken(), DefaultAccountDao.this.clock.getUTCNow());
                try {
                    DefaultAccountDao.this.eventBus.postFromTransaction((BusEvent)changeEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
                }
                catch (PersistentBus.EventBusException e) {
                    log.warn("Failed to post account change event for accountId='{}'", (Object)accountId, (Object)e);
                }
                return null;
            }
        });
    }

    @Override
    public void updatePaymentMethod(final UUID accountId, final UUID paymentMethodId, final InternalCallContext context) throws AccountApiException {
        this.transactionalSqlDao.execute(AccountApiException.class, (EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws EntityPersistenceException, PersistentBus.EventBusException {
                AccountSqlDao transactional = (AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class);
                AccountModelDao currentAccount = (AccountModelDao)transactional.getById(accountId.toString(), (InternalTenantContext)context);
                if (currentAccount == null) {
                    throw new EntityPersistenceException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{accountId});
                }
                if (currentAccount.getPaymentMethodId() == null && paymentMethodId == null || currentAccount.getPaymentMethodId() != null && currentAccount.getPaymentMethodId().equals(paymentMethodId)) {
                    return null;
                }
                String thePaymentMethodId = paymentMethodId != null ? paymentMethodId.toString() : null;
                AccountModelDao account = (AccountModelDao)((Object)transactional.updatePaymentMethod(accountId.toString(), thePaymentMethodId, context));
                DefaultAccountChangeEvent changeEvent = new DefaultAccountChangeEvent(accountId, currentAccount, account, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken(), DefaultAccountDao.this.clock.getUTCNow());
                try {
                    DefaultAccountDao.this.eventBus.postFromTransaction((BusEvent)changeEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
                }
                catch (PersistentBus.EventBusException e) {
                    log.warn("Failed to post account change event for accountId='{}'", (Object)accountId, (Object)e);
                }
                return null;
            }
        });
    }

    @Override
    public void addEmail(final AccountEmailModelDao email, final InternalCallContext context) throws AccountApiException {
        this.transactionalSqlDao.execute(AccountApiException.class, (EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                AccountEmailSqlDao transactional = (AccountEmailSqlDao)entitySqlDaoWrapperFactory.become(AccountEmailSqlDao.class);
                if (transactional.getById(email.getId().toString(), (InternalTenantContext)context) != null) {
                    throw new AccountApiException(ErrorCode.ACCOUNT_EMAIL_ALREADY_EXISTS, new Object[]{email.getId()});
                }
                DefaultAccountDao.this.createAndRefresh(transactional, email, context);
                return null;
            }
        });
    }

    @Override
    public void removeEmail(final AccountEmailModelDao email, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                ((AccountEmailSqlDao)entitySqlDaoWrapperFactory.become(AccountEmailSqlDao.class)).markEmailAsDeleted(email, context);
                return null;
            }
        });
    }

    @Override
    public List<AccountEmailModelDao> getEmailsByAccountId(final UUID accountId, final InternalTenantContext context) {
        return (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<AccountEmailModelDao>>(){

            public List<AccountEmailModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return ((AccountEmailSqlDao)entitySqlDaoWrapperFactory.become(AccountEmailSqlDao.class)).getEmailByAccountId(accountId, context);
            }
        });
    }

    @Override
    public Integer getAccountBCD(final UUID accountId, final InternalTenantContext context) {
        return (Integer)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Integer>(){

            public Integer inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return ((AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class)).getBCD(accountId.toString(), context);
            }
        });
    }

    @Override
    public List<AccountModelDao> getAccountsByParentId(final UUID parentAccountId, final InternalTenantContext context) {
        return (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<AccountModelDao>>(){

            public List<AccountModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return ((AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class)).getAccountsByParentId(parentAccountId, context);
            }
        });
    }
}

