/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.UUID;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.events.AccountCreationInternalEvent;
import org.killbill.billing.events.BusEventBase;
import org.killbill.billing.events.BusInternalEvent;

public class DefaultAccountCreationEvent
extends BusEventBase
implements AccountCreationInternalEvent {
    private final UUID id;
    private final AccountData data;

    @JsonCreator
    public DefaultAccountCreationEvent(@JsonProperty(value="data") DefaultAccountData data, @JsonProperty(value="id") UUID id, @JsonProperty(value="searchKey1") Long searchKey1, @JsonProperty(value="searchKey2") Long searchKey2, @JsonProperty(value="userToken") UUID userToken) {
        super(searchKey1, searchKey2, userToken);
        this.id = id;
        this.data = data;
    }

    @JsonIgnore
    public BusInternalEvent.BusInternalEventType getBusEventType() {
        return BusInternalEvent.BusInternalEventType.ACCOUNT_CREATE;
    }

    public UUID getId() {
        return this.id;
    }

    public AccountData getData() {
        return this.data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DefaultAccountCreationEvent other = (DefaultAccountCreationEvent)((Object)obj);
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static class DefaultAccountData
    implements AccountData {
        private final String externalKey;
        private final String name;
        private final Integer firstNameLength;
        private final String email;
        private final Integer billCycleDayLocal;
        private final String currency;
        private final UUID parentAccountId;
        private final Boolean isPaymentDelegatedToParent;
        private final UUID paymentMethodId;
        private final String timeZone;
        private final String locale;
        private final String address1;
        private final String address2;
        private final String companyName;
        private final String city;
        private final String stateOrProvince;
        private final String postalCode;
        private final String country;
        private final String phone;
        private final String notes;
        private final Boolean isMigrated;
        private final Boolean isNotifiedForInvoices;

        public DefaultAccountData(AccountModelDao d) {
            this(d.getExternalKey(), d.getName(), d.getFirstNameLength(), d.getEmail(), d.getBillingCycleDayLocal(), d.getCurrency() != null ? d.getCurrency().name() : null, d.getParentAccountId(), d.getIsPaymentDelegatedToParent(), d.getPaymentMethodId(), d.getTimeZone() != null ? d.getTimeZone().getID() : null, d.getLocale(), d.getAddress1(), d.getAddress2(), d.getCompanyName(), d.getCity(), d.getStateOrProvince(), d.getPostalCode(), d.getCountry(), d.getPhone(), d.getNotes(), d.getMigrated(), d.getIsNotifiedForInvoices());
        }

        @JsonCreator
        public DefaultAccountData(@JsonProperty(value="externalKey") String externalKey, @JsonProperty(value="name") String name, @JsonProperty(value="firstNameLength") Integer firstNameLength, @JsonProperty(value="email") String email, @JsonProperty(value="billCycleDayLocal") Integer billCycleDayLocal, @JsonProperty(value="currency") String currency, @JsonProperty(value="parentAccountId") UUID parentAccountId, @JsonProperty(value="isPaymentDelegatedToParent") Boolean isPaymentDelegatedToParent, @JsonProperty(value="paymentMethodId") UUID paymentMethodId, @JsonProperty(value="timeZone") String timeZone, @JsonProperty(value="locale") String locale, @JsonProperty(value="address1") String address1, @JsonProperty(value="address2") String address2, @JsonProperty(value="companyName") String companyName, @JsonProperty(value="city") String city, @JsonProperty(value="stateOrProvince") String stateOrProvince, @JsonProperty(value="postalCode") String postalCode, @JsonProperty(value="country") String country, @JsonProperty(value="phone") String phone, @JsonProperty(value="notes") String notes, @JsonProperty(value="isMigrated") Boolean isMigrated, @JsonProperty(value="isNotifiedForInvoices") Boolean isNotifiedForInvoices) {
            this.externalKey = externalKey;
            this.name = name;
            this.firstNameLength = firstNameLength;
            this.email = email;
            this.billCycleDayLocal = billCycleDayLocal;
            this.currency = currency;
            this.parentAccountId = parentAccountId;
            this.isPaymentDelegatedToParent = isPaymentDelegatedToParent;
            this.paymentMethodId = paymentMethodId;
            this.timeZone = timeZone;
            this.locale = locale;
            this.address1 = address1;
            this.address2 = address2;
            this.companyName = companyName;
            this.city = city;
            this.stateOrProvince = stateOrProvince;
            this.postalCode = postalCode;
            this.country = country;
            this.phone = phone;
            this.notes = notes;
            this.isMigrated = isMigrated;
            this.isNotifiedForInvoices = isNotifiedForInvoices;
        }

        public String getExternalKey() {
            return this.externalKey;
        }

        public String getName() {
            return this.name;
        }

        public Integer getFirstNameLength() {
            return this.firstNameLength;
        }

        public String getEmail() {
            return this.email;
        }

        public Integer getBillCycleDayLocal() {
            return this.billCycleDayLocal;
        }

        public Currency getCurrency() {
            if (Strings.emptyToNull((String)this.currency) == null) {
                return null;
            }
            return Currency.valueOf((String)this.currency);
        }

        public UUID getParentAccountId() {
            return this.parentAccountId;
        }

        @JsonIgnore
        public Boolean isPaymentDelegatedToParent() {
            return this.isPaymentDelegatedToParent;
        }

        @JsonIgnore
        public DateTimeZone getTimeZone() {
            if (Strings.emptyToNull((String)this.timeZone) == null) {
                return null;
            }
            return DateTimeZone.forID((String)this.timeZone);
        }

        @JsonProperty(value="timeZone")
        public String getTimeZoneString() {
            return this.timeZone;
        }

        public String getLocale() {
            return this.locale;
        }

        public String getAddress1() {
            return this.address1;
        }

        public String getAddress2() {
            return this.address2;
        }

        public String getCompanyName() {
            return this.companyName;
        }

        public String getCity() {
            return this.city;
        }

        public String getStateOrProvince() {
            return this.stateOrProvince;
        }

        public String getPostalCode() {
            return this.postalCode;
        }

        public String getCountry() {
            return this.country;
        }

        public String getPhone() {
            return this.phone;
        }

        public String getNotes() {
            return this.notes;
        }

        public UUID getPaymentMethodId() {
            return this.paymentMethodId;
        }

        @JsonIgnore
        public Boolean isMigrated() {
            return this.isMigrated;
        }

        @JsonIgnore
        public Boolean isNotifiedForInvoices() {
            return this.isNotifiedForInvoices;
        }

        public Boolean getIsMigrated() {
            return this.isMigrated;
        }

        public Boolean getIsNotifiedForInvoices() {
            return this.isNotifiedForInvoices;
        }

        public Boolean getIsPaymentDelegatedToParent() {
            return this.isPaymentDelegatedToParent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultAccountData that = (DefaultAccountData)o;
            if (this.billCycleDayLocal != null ? !this.billCycleDayLocal.equals(that.billCycleDayLocal) : that.billCycleDayLocal != null) {
                return false;
            }
            if (this.isMigrated != null ? !this.isMigrated.equals(that.isMigrated) : that.isMigrated != null) {
                return false;
            }
            if (this.isNotifiedForInvoices != null ? !this.isNotifiedForInvoices.equals(that.isNotifiedForInvoices) : that.isNotifiedForInvoices != null) {
                return false;
            }
            if (this.address1 != null ? !this.address1.equals(that.address1) : that.address1 != null) {
                return false;
            }
            if (this.address2 != null ? !this.address2.equals(that.address2) : that.address2 != null) {
                return false;
            }
            if (this.city != null ? !this.city.equals(that.city) : that.city != null) {
                return false;
            }
            if (this.companyName != null ? !this.companyName.equals(that.companyName) : that.companyName != null) {
                return false;
            }
            if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
                return false;
            }
            if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
                return false;
            }
            if (this.parentAccountId != null ? !this.parentAccountId.equals(that.parentAccountId) : that.parentAccountId != null) {
                return false;
            }
            if (this.isPaymentDelegatedToParent != null ? !this.isPaymentDelegatedToParent.equals(that.isPaymentDelegatedToParent) : that.isPaymentDelegatedToParent != null) {
                return false;
            }
            if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
                return false;
            }
            if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
                return false;
            }
            if (this.firstNameLength != null ? !this.firstNameLength.equals(that.firstNameLength) : that.firstNameLength != null) {
                return false;
            }
            if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
                return false;
            }
            if (this.phone != null ? !this.phone.equals(that.phone) : that.phone != null) {
                return false;
            }
            if (this.notes != null ? !this.notes.equals(that.notes) : that.notes != null) {
                return false;
            }
            if (this.postalCode != null ? !this.postalCode.equals(that.postalCode) : that.postalCode != null) {
                return false;
            }
            if (this.stateOrProvince != null ? !this.stateOrProvince.equals(that.stateOrProvince) : that.stateOrProvince != null) {
                return false;
            }
            return !(this.timeZone != null ? !this.timeZone.equals(that.timeZone) : that.timeZone != null);
        }

        public int hashCode() {
            int result = this.externalKey != null ? this.externalKey.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.firstNameLength != null ? this.firstNameLength.hashCode() : 0);
            result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
            result = 31 * result + (this.billCycleDayLocal != null ? this.billCycleDayLocal.hashCode() : 0);
            result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
            result = 31 * result + (this.parentAccountId != null ? this.parentAccountId.hashCode() : 0);
            result = 31 * result + (this.isPaymentDelegatedToParent != null ? this.isPaymentDelegatedToParent.hashCode() : 0);
            result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
            result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            result = 31 * result + (this.address1 != null ? this.address1.hashCode() : 0);
            result = 31 * result + (this.address2 != null ? this.address2.hashCode() : 0);
            result = 31 * result + (this.companyName != null ? this.companyName.hashCode() : 0);
            result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
            result = 31 * result + (this.stateOrProvince != null ? this.stateOrProvince.hashCode() : 0);
            result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
            result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
            result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
            result = 31 * result + (this.notes != null ? this.notes.hashCode() : 0);
            result = 31 * result + (this.isMigrated != null ? this.isMigrated.hashCode() : 0);
            result = 31 * result + (this.isNotifiedForInvoices != null ? this.isNotifiedForInvoices.hashCode() : 0);
            return result;
        }
    }
}

