/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.account.api.DefaultChangedField;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.events.AccountChangeInternalEvent;
import org.killbill.billing.events.BusEventBase;
import org.killbill.billing.events.BusInternalEvent;
import org.killbill.billing.events.ChangedField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccountChangeEvent
extends BusEventBase
implements AccountChangeInternalEvent {
    private final List<ChangedField> changedFields;
    private final UUID accountId;

    @JsonCreator
    public DefaultAccountChangeEvent(@JsonProperty(value="changeFields") List<ChangedField> changedFields, @JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="searchKey1") Long searchKey1, @JsonProperty(value="searchKey2") Long searchKey2, @JsonProperty(value="userToken") UUID userToken) {
        super(searchKey1, searchKey2, userToken);
        this.accountId = accountId;
        this.changedFields = changedFields;
    }

    public DefaultAccountChangeEvent(UUID id, AccountModelDao oldData, AccountModelDao newData, Long searchKey1, Long searchKey2, UUID userToken, DateTime changeDate) {
        super(searchKey1, searchKey2, userToken);
        this.accountId = id;
        this.changedFields = this.calculateChangedFields(oldData, newData, changeDate);
    }

    @JsonIgnore
    public BusInternalEvent.BusInternalEventType getBusEventType() {
        return BusInternalEvent.BusInternalEventType.ACCOUNT_CHANGE;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    @JsonDeserialize(contentAs=DefaultChangedField.class)
    public List<ChangedField> getChangedFields() {
        return this.changedFields;
    }

    @JsonIgnore
    public boolean hasChanges() {
        return !this.changedFields.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountId == null ? 0 : this.accountId.hashCode());
        result = 31 * result + (this.changedFields == null ? 0 : this.changedFields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DefaultAccountChangeEvent other = (DefaultAccountChangeEvent)((Object)obj);
        if (this.accountId == null ? other.accountId != null : !this.accountId.equals(other.accountId)) {
            return false;
        }
        return !(this.changedFields == null ? other.changedFields != null : !this.changedFields.equals(other.changedFields));
    }

    private List<ChangedField> calculateChangedFields(AccountModelDao oldData, AccountModelDao newData, DateTime changeDate) {
        ArrayList<ChangedField> tmpChangedFields = new ArrayList<ChangedField>();
        this.addIfValueChanged(tmpChangedFields, "externalKey", oldData.getExternalKey(), newData.getExternalKey(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "email", oldData.getEmail(), newData.getEmail(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "firstName", oldData.getName(), newData.getName(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "currency", oldData.getCurrency() != null ? oldData.getCurrency().toString() : null, newData.getCurrency() != null ? newData.getCurrency().toString() : null, changeDate);
        this.addIfValueChanged(tmpChangedFields, "billCycleDayLocal", String.valueOf(oldData.getBillingCycleDayLocal()), String.valueOf(newData.getBillingCycleDayLocal()), changeDate);
        this.addIfValueChanged(tmpChangedFields, "paymentMethodId", oldData.getPaymentMethodId() != null ? oldData.getPaymentMethodId().toString() : null, newData.getPaymentMethodId() != null ? newData.getPaymentMethodId().toString() : null, changeDate);
        this.addIfValueChanged(tmpChangedFields, "locale", oldData.getLocale(), newData.getLocale(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "timeZone", oldData.getTimeZone() == null ? null : oldData.getTimeZone().toString(), newData.getTimeZone() == null ? null : newData.getTimeZone().toString(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "address1", oldData.getAddress1(), newData.getAddress1(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "address2", oldData.getAddress2(), newData.getAddress2(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "city", oldData.getCity(), newData.getCity(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "stateOrProvince", oldData.getStateOrProvince(), newData.getStateOrProvince(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "country", oldData.getCountry(), newData.getCountry(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "postalCode", oldData.getPostalCode(), newData.getPostalCode(), changeDate);
        this.addIfValueChanged(tmpChangedFields, "phone", oldData.getPhone(), newData.getPhone(), changeDate);
        return tmpChangedFields;
    }

    private void addIfValueChanged(Collection<ChangedField> inputList, String key, String oldData, String newData, DateTime changeDate) {
        if (newData != null || oldData != null) {
            if (newData == null || oldData == null) {
                inputList.add(new DefaultChangedField(key, oldData, newData, changeDate));
            } else if (!newData.equals(oldData)) {
                inputList.add(new DefaultChangedField(key, oldData, newData, changeDate));
            }
        }
    }
}

