/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.svcs;

import com.google.inject.Inject;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultImmutableAccountData;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.account.api.ImmutableAccountInternalApi;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.account.dao.AccountSqlDao;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.cache.ImmutableAccountCacheLoader;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.IDBI;

public class DefaultImmutableAccountInternalApi
implements ImmutableAccountInternalApi {
    private final EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao;
    private final NonEntityDao nonEntityDao;
    private final CacheController<Long, ImmutableAccountData> accountCacheController;
    private final CacheController<String, Long> recordIdCacheController;

    @Inject
    public DefaultImmutableAccountInternalApi(IDBI dbi, Clock clock, NonEntityDao nonEntityDao, CacheControllerDispatcher cacheControllerDispatcher) {
        this.transactionalSqlDao = new EntitySqlDaoTransactionalJdbiWrapper(dbi, clock, cacheControllerDispatcher, nonEntityDao, null);
        this.nonEntityDao = nonEntityDao;
        this.accountCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_IMMUTABLE);
        this.recordIdCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.RECORD_ID);
    }

    public ImmutableAccountData getImmutableAccountDataById(UUID accountId, InternalTenantContext context) throws AccountApiException {
        Long recordId = this.nonEntityDao.retrieveRecordIdFromObject(accountId, ObjectType.ACCOUNT, this.recordIdCacheController);
        return this.getImmutableAccountDataByRecordId(recordId, context);
    }

    public ImmutableAccountData getImmutableAccountDataByRecordId(Long recordId, InternalTenantContext context) throws AccountApiException {
        CacheLoaderArgument arg = this.createImmutableAccountCacheLoaderArgument(context);
        return (ImmutableAccountData)this.accountCacheController.get((Object)recordId, arg);
    }

    private CacheLoaderArgument createImmutableAccountCacheLoaderArgument(InternalTenantContext context) {
        ImmutableAccountCacheLoader.LoaderCallback loaderCallback = new ImmutableAccountCacheLoader.LoaderCallback(){

            public ImmutableAccountData loadAccount(Long recordId, InternalTenantContext context) {
                Account account = DefaultImmutableAccountInternalApi.this.getAccountByRecordIdInternal(recordId, context);
                return account != null ? new DefaultImmutableAccountData(account) : null;
            }
        };
        Object[] args = new Object[]{loaderCallback};
        return new CacheLoaderArgument(null, args, context);
    }

    private Account getAccountByRecordIdInternal(final Long recordId, final InternalTenantContext context) {
        AccountModelDao accountModelDao = (AccountModelDao)((Object)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<AccountModelDao>(){

            public AccountModelDao inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                EntitySqlDao transactional = entitySqlDaoWrapperFactory.become(AccountSqlDao.class);
                return (AccountModelDao)transactional.getByRecordId(recordId, context);
            }
        }));
        return accountModelDao != null ? new DefaultAccount(accountModelDao) : null;
    }
}

