/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api;

import java.util.UUID;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.catalog.api.Currency;

public class DefaultMutableAccountData
implements MutableAccountData {
    public static final int DEFAULT_BILLING_CYCLE_DAY_LOCAL = 0;
    private String externalKey;
    private String email;
    private String name;
    private Integer firstNameLength;
    private Currency currency;
    private UUID parentAccountId;
    private Boolean isPaymentDelegatedToParent;
    private int billCycleDayLocal;
    private UUID paymentMethodId;
    private DateTimeZone timeZone;
    private String locale;
    private String address1;
    private String address2;
    private String companyName;
    private String city;
    private String stateOrProvince;
    private String country;
    private String postalCode;
    private String phone;
    private String notes;
    private Boolean isMigrated;
    private Boolean isNotifiedForInvoices;

    public DefaultMutableAccountData(String externalKey, String email, String name, int firstNameLength, Currency currency, UUID parentAccountId, Boolean isPaymentDelegatedToParent, int billCycleDayLocal, UUID paymentMethodId, DateTimeZone timeZone, String locale, String address1, String address2, String companyName, String city, String stateOrProvince, String country, String postalCode, String phone, String notes, boolean isMigrated, boolean isNotifiedForInvoices) {
        this.externalKey = externalKey;
        this.email = email;
        this.name = name;
        this.firstNameLength = firstNameLength;
        this.currency = currency;
        this.parentAccountId = parentAccountId;
        this.isPaymentDelegatedToParent = isPaymentDelegatedToParent;
        this.billCycleDayLocal = billCycleDayLocal;
        this.paymentMethodId = paymentMethodId;
        this.timeZone = timeZone;
        this.locale = locale;
        this.address1 = address1;
        this.address2 = address2;
        this.companyName = companyName;
        this.city = city;
        this.stateOrProvince = stateOrProvince;
        this.country = country;
        this.postalCode = postalCode;
        this.phone = phone;
        this.notes = notes;
        this.isMigrated = isMigrated;
        this.isNotifiedForInvoices = isNotifiedForInvoices;
    }

    public DefaultMutableAccountData(AccountData accountData) {
        this.externalKey = accountData.getExternalKey();
        this.email = accountData.getEmail();
        this.name = accountData.getName();
        this.firstNameLength = accountData.getFirstNameLength();
        this.currency = accountData.getCurrency();
        this.parentAccountId = accountData.getParentAccountId();
        this.isPaymentDelegatedToParent = accountData.isPaymentDelegatedToParent();
        this.billCycleDayLocal = accountData.getBillCycleDayLocal() == null ? 0 : accountData.getBillCycleDayLocal();
        this.paymentMethodId = accountData.getPaymentMethodId();
        this.timeZone = accountData.getTimeZone();
        this.locale = accountData.getLocale();
        this.address1 = accountData.getAddress1();
        this.address2 = accountData.getAddress2();
        this.companyName = accountData.getCompanyName();
        this.city = accountData.getCity();
        this.stateOrProvince = accountData.getStateOrProvince();
        this.country = accountData.getCountry();
        this.postalCode = accountData.getPostalCode();
        this.phone = accountData.getPhone();
        this.notes = accountData.getNotes();
        this.isMigrated = accountData.isMigrated();
        this.isNotifiedForInvoices = accountData.isNotifiedForInvoices();
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getFirstNameLength() {
        return this.firstNameLength;
    }

    public void setFirstNameLength(int firstNameLength) {
        this.firstNameLength = firstNameLength;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Integer getBillCycleDayLocal() {
        return this.billCycleDayLocal;
    }

    public void setBillCycleDayLocal(int billCycleDayLocal) {
        this.billCycleDayLocal = billCycleDayLocal;
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(UUID paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Boolean isMigrated() {
        return this.isMigrated;
    }

    public Boolean isNotifiedForInvoices() {
        return this.isNotifiedForInvoices;
    }

    public void setIsMigrated(boolean isMigrated) {
        this.isMigrated = isMigrated;
    }

    public void setIsNotifiedForInvoices(boolean isNotifiedForInvoices) {
        this.isNotifiedForInvoices = isNotifiedForInvoices;
    }

    public UUID getParentAccountId() {
        return this.parentAccountId;
    }

    public void setParentAccountId(UUID parentAccountId) {
        this.parentAccountId = parentAccountId;
    }

    public void setIsPaymentDelegatedToParent(boolean isPaymentDelegatedToParent) {
        this.isPaymentDelegatedToParent = isPaymentDelegatedToParent;
    }

    public Boolean isPaymentDelegatedToParent() {
        return this.isPaymentDelegatedToParent;
    }
}

