/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api;

import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.DefaultMutableAccountData;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.entity.EntityBase;
import org.killbill.billing.util.account.AccountDateTimeUtils;
import org.killbill.billing.util.entity.Entity;

public class DefaultAccount
extends EntityBase
implements Account {
    private final String externalKey;
    private final String email;
    private final String name;
    private final Integer firstNameLength;
    private final Currency currency;
    private final UUID parentAccountId;
    private final Boolean isPaymentDelegatedToParent;
    private final Integer billCycleDayLocal;
    private final UUID paymentMethodId;
    private final DateTimeZone timeZone;
    private final String locale;
    private final String address1;
    private final String address2;
    private final String companyName;
    private final String city;
    private final String stateOrProvince;
    private final String country;
    private final String postalCode;
    private final String phone;
    private final String notes;
    private final Boolean isMigrated;
    private final Boolean isNotifiedForInvoices;

    public DefaultAccount(UUID id, AccountData data) {
        this(id, data.getExternalKey(), data.getEmail(), data.getName(), data.getFirstNameLength(), data.getCurrency(), data.getParentAccountId(), data.isPaymentDelegatedToParent(), data.getBillCycleDayLocal(), data.getPaymentMethodId(), data.getTimeZone(), data.getLocale(), data.getAddress1(), data.getAddress2(), data.getCompanyName(), data.getCity(), data.getStateOrProvince(), data.getCountry(), data.getPostalCode(), data.getPhone(), data.getNotes(), data.isMigrated(), data.isNotifiedForInvoices());
    }

    public DefaultAccount(UUID id, String externalKey, String email, String name, Integer firstNameLength, Currency currency, UUID parentAccountId, Boolean isPaymentDelegatedToParent, Integer billCycleDayLocal, UUID paymentMethodId, DateTimeZone timeZone, String locale, String address1, String address2, String companyName, String city, String stateOrProvince, String country, String postalCode, String phone, String notes, Boolean isMigrated, Boolean isNotifiedForInvoices) {
        this(id, null, null, externalKey, email, name, firstNameLength, currency, parentAccountId, isPaymentDelegatedToParent, billCycleDayLocal, paymentMethodId, timeZone, locale, address1, address2, companyName, city, stateOrProvince, country, postalCode, phone, notes, isMigrated, isNotifiedForInvoices);
    }

    public DefaultAccount(UUID id, @Nullable DateTime createdDate, @Nullable DateTime updatedDate, String externalKey, String email, String name, Integer firstNameLength, Currency currency, UUID parentAccountId, Boolean isPaymentDelegatedToParent, Integer billCycleDayLocal, UUID paymentMethodId, DateTimeZone timeZone, String locale, String address1, String address2, String companyName, String city, String stateOrProvince, String country, String postalCode, String phone, String notes, Boolean isMigrated, Boolean isNotifiedForInvoices) {
        super(id, createdDate, updatedDate);
        this.externalKey = externalKey;
        this.email = email;
        this.name = name;
        this.firstNameLength = firstNameLength;
        this.currency = currency;
        this.parentAccountId = parentAccountId;
        this.isPaymentDelegatedToParent = isPaymentDelegatedToParent != null ? isPaymentDelegatedToParent : false;
        this.billCycleDayLocal = billCycleDayLocal == null ? 0 : billCycleDayLocal;
        this.paymentMethodId = paymentMethodId;
        this.timeZone = timeZone;
        this.locale = locale;
        this.address1 = address1;
        this.address2 = address2;
        this.companyName = companyName;
        this.city = city;
        this.stateOrProvince = stateOrProvince;
        this.postalCode = postalCode;
        this.country = country;
        this.phone = phone;
        this.notes = notes;
        this.isMigrated = isMigrated;
        this.isNotifiedForInvoices = isNotifiedForInvoices;
    }

    public DefaultAccount(AccountModelDao accountModelDao) {
        this(accountModelDao.getId(), accountModelDao.getCreatedDate(), accountModelDao.getUpdatedDate(), accountModelDao.getExternalKey(), accountModelDao.getEmail(), accountModelDao.getName(), accountModelDao.getFirstNameLength(), accountModelDao.getCurrency(), accountModelDao.getParentAccountId(), accountModelDao.getIsPaymentDelegatedToParent(), accountModelDao.getBillingCycleDayLocal(), accountModelDao.getPaymentMethodId(), accountModelDao.getTimeZone(), accountModelDao.getLocale(), accountModelDao.getAddress1(), accountModelDao.getAddress2(), accountModelDao.getCompanyName(), accountModelDao.getCity(), accountModelDao.getStateOrProvince(), accountModelDao.getCountry(), accountModelDao.getPostalCode(), accountModelDao.getPhone(), accountModelDao.getNotes(), accountModelDao.getMigrated(), accountModelDao.getIsNotifiedForInvoices());
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public Integer getFirstNameLength() {
        return this.firstNameLength;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public UUID getParentAccountId() {
        return this.parentAccountId;
    }

    public Boolean isPaymentDelegatedToParent() {
        return this.isPaymentDelegatedToParent;
    }

    public Integer getBillCycleDayLocal() {
        return this.billCycleDayLocal;
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getCity() {
        return this.city;
    }

    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public Boolean isMigrated() {
        return this.isMigrated;
    }

    public Boolean isNotifiedForInvoices() {
        return this.isNotifiedForInvoices;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getNotes() {
        return this.notes;
    }

    public MutableAccountData toMutableAccountData() {
        return new DefaultMutableAccountData((AccountData)this);
    }

    public Account mergeWithDelegate(Account currentAccount) {
        Boolean isNotifiedForInvoices;
        Boolean isMigrated;
        Integer firstNameLength;
        DefaultMutableAccountData accountData = new DefaultMutableAccountData((AccountData)this);
        this.validateAccountUpdateInput(currentAccount, false);
        accountData.setExternalKey(currentAccount.getExternalKey());
        accountData.setCurrency(currentAccount.getCurrency());
        if (currentAccount.getBillCycleDayLocal() == 0 && this.billCycleDayLocal != null && this.billCycleDayLocal != 0) {
            accountData.setBillCycleDayLocal(this.billCycleDayLocal);
        } else {
            accountData.setBillCycleDayLocal(currentAccount.getBillCycleDayLocal());
        }
        accountData.setEmail(this.email != null ? this.email : currentAccount.getEmail());
        accountData.setName(this.name != null ? this.name : currentAccount.getName());
        Integer n = firstNameLength = this.firstNameLength != null ? this.firstNameLength : currentAccount.getFirstNameLength();
        if (firstNameLength != null) {
            accountData.setFirstNameLength(firstNameLength);
        }
        accountData.setPaymentMethodId(this.paymentMethodId != null ? this.paymentMethodId : currentAccount.getPaymentMethodId());
        accountData.setTimeZone(this.timeZone != null ? this.timeZone : currentAccount.getTimeZone());
        accountData.setLocale(this.locale != null ? this.locale : currentAccount.getLocale());
        accountData.setAddress1(this.address1 != null ? this.address1 : currentAccount.getAddress1());
        accountData.setAddress2(this.address2 != null ? this.address2 : currentAccount.getAddress2());
        accountData.setCompanyName(this.companyName != null ? this.companyName : currentAccount.getCompanyName());
        accountData.setCity(this.city != null ? this.city : currentAccount.getCity());
        accountData.setStateOrProvince(this.stateOrProvince != null ? this.stateOrProvince : currentAccount.getStateOrProvince());
        accountData.setCountry(this.country != null ? this.country : currentAccount.getCountry());
        accountData.setPostalCode(this.postalCode != null ? this.postalCode : currentAccount.getPostalCode());
        accountData.setPhone(this.phone != null ? this.phone : currentAccount.getPhone());
        accountData.setNotes(this.notes != null ? this.notes : currentAccount.getNotes());
        accountData.setParentAccountId(this.parentAccountId != null ? this.parentAccountId : currentAccount.getParentAccountId());
        accountData.setIsPaymentDelegatedToParent(this.isPaymentDelegatedToParent != null ? this.isPaymentDelegatedToParent : currentAccount.isPaymentDelegatedToParent());
        Boolean bl = isMigrated = this.isMigrated != null ? this.isMigrated : currentAccount.isMigrated();
        if (isMigrated != null) {
            accountData.setIsMigrated(isMigrated);
        }
        Boolean bl2 = isNotifiedForInvoices = this.isNotifiedForInvoices != null ? this.isNotifiedForInvoices : currentAccount.isNotifiedForInvoices();
        if (isNotifiedForInvoices != null) {
            accountData.setIsNotifiedForInvoices(isNotifiedForInvoices);
        }
        return new DefaultAccount(currentAccount.getId(), (AccountData)accountData);
    }

    public DateTimeZone getFixedOffsetTimeZone() {
        return AccountDateTimeUtils.getFixedOffsetTimeZone((Account)this);
    }

    public DateTime getReferenceTime() {
        return AccountDateTimeUtils.getReferenceDateTime((Entity)this);
    }

    public String toString() {
        return "DefaultAccount [externalKey=" + this.externalKey + ", email=" + this.email + ", name=" + this.name + ", firstNameLength=" + this.firstNameLength + ", phone=" + this.phone + ", currency=" + this.currency + ", parentAccountId=" + this.parentAccountId + ", isPaymentDelegatedToParent=" + this.isPaymentDelegatedToParent + ", billCycleDayLocal=" + this.billCycleDayLocal + ", paymentMethodId=" + this.paymentMethodId + ", timezone=" + this.timeZone + ", locale=" + this.locale + ", address1=" + this.address1 + ", address2=" + this.address2 + ", companyName=" + this.companyName + ", city=" + this.city + ", stateOrProvince=" + this.stateOrProvince + ", postalCode=" + this.postalCode + ", country=" + this.country + ", notes=" + this.notes + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultAccount that = (DefaultAccount)((Object)o);
        if (this.billCycleDayLocal != null ? !this.billCycleDayLocal.equals(that.billCycleDayLocal) : that.billCycleDayLocal != null) {
            return false;
        }
        if (this.address1 != null ? !this.address1.equals(that.address1) : that.address1 != null) {
            return false;
        }
        if (this.address2 != null ? !this.address2.equals(that.address2) : that.address2 != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(that.city) : that.city != null) {
            return false;
        }
        if (this.companyName != null ? !this.companyName.equals(that.companyName) : that.companyName != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.parentAccountId != null ? !this.parentAccountId.equals(that.parentAccountId) : that.parentAccountId != null) {
            return false;
        }
        if (this.isPaymentDelegatedToParent != null ? !this.isPaymentDelegatedToParent.equals(that.isPaymentDelegatedToParent) : that.isPaymentDelegatedToParent != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.firstNameLength != null ? !this.firstNameLength.equals(that.firstNameLength) : that.firstNameLength != null) {
            return false;
        }
        if (this.isMigrated != null ? !this.isMigrated.equals(that.isMigrated) : that.isMigrated != null) {
            return false;
        }
        if (this.isNotifiedForInvoices != null ? !this.isNotifiedForInvoices.equals(that.isNotifiedForInvoices) : that.isNotifiedForInvoices != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.phone != null ? !this.phone.equals(that.phone) : that.phone != null) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(that.postalCode) : that.postalCode != null) {
            return false;
        }
        if (this.stateOrProvince != null ? !this.stateOrProvince.equals(that.stateOrProvince) : that.stateOrProvince != null) {
            return false;
        }
        if (this.timeZone != null ? !this.timeZone.equals((Object)that.timeZone) : that.timeZone != null) {
            return false;
        }
        return !(this.notes != null ? !this.notes.equals(that.notes) : that.notes != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.firstNameLength != null ? this.firstNameLength.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.parentAccountId != null ? this.parentAccountId.hashCode() : 0);
        result = 31 * result + (this.isPaymentDelegatedToParent != null ? this.isPaymentDelegatedToParent.hashCode() : 0);
        result = 31 * result + this.billCycleDayLocal;
        result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.address1 != null ? this.address1.hashCode() : 0);
        result = 31 * result + (this.address2 != null ? this.address2.hashCode() : 0);
        result = 31 * result + (this.companyName != null ? this.companyName.hashCode() : 0);
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.stateOrProvince != null ? this.stateOrProvince.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
        result = 31 * result + (this.notes != null ? this.notes.hashCode() : 0);
        result = 31 * result + (this.isMigrated != null ? this.isMigrated.hashCode() : 0);
        result = 31 * result + (this.isNotifiedForInvoices != null ? this.isNotifiedForInvoices.hashCode() : 0);
        return result;
    }

    public void validateAccountUpdateInput(Account currentAccount, boolean ignoreNullInput) {
        if ((ignoreNullInput || this.externalKey != null) && currentAccount.getExternalKey() != null && !currentAccount.getExternalKey().equals(this.externalKey)) {
            throw new IllegalArgumentException(String.format("Killbill doesn't support updating the account external key yet: new=%s, current=%s", this.externalKey, currentAccount.getExternalKey()));
        }
        if ((ignoreNullInput || this.currency != null) && currentAccount.getCurrency() != null && !currentAccount.getCurrency().equals((Object)this.currency)) {
            throw new IllegalArgumentException(String.format("Killbill doesn't support updating the account currency yet: new=%s, current=%s", this.currency, currentAccount.getCurrency()));
        }
        if ((ignoreNullInput || this.billCycleDayLocal != null && this.billCycleDayLocal != 0) && currentAccount.getBillCycleDayLocal() != 0 && !currentAccount.getBillCycleDayLocal().equals(this.billCycleDayLocal)) {
            throw new IllegalArgumentException(String.format("Killbill doesn't support updating the account BCD yet: new=%s, current=%s", this.billCycleDayLocal, currentAccount.getBillCycleDayLocal()));
        }
        if ((ignoreNullInput || this.timeZone != null) && currentAccount.getTimeZone() != null && !currentAccount.getTimeZone().equals((Object)this.timeZone)) {
            throw new IllegalArgumentException(String.format("Killbill doesn't support updating the account timeZone yet: new=%s, current=%s", this.timeZone, currentAccount.getTimeZone()));
        }
    }
}

