/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.dao;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultMutableAccountData;
import org.killbill.billing.account.api.user.DefaultAccountChangeEvent;
import org.killbill.billing.account.api.user.DefaultAccountCreationEvent;
import org.killbill.billing.account.dao.AccountDao;
import org.killbill.billing.account.dao.AccountEmailModelDao;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.entity.DefaultPagination;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.MockEntityDaoBase;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.testng.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockAccountDao
extends MockEntityDaoBase<AccountModelDao, Account, AccountApiException>
implements AccountDao {
    private final MockEntityDaoBase<AccountModelDao, Account, AccountApiException> accountSqlDao = new MockEntityDaoBase();
    private final MockEntityDaoBase<AccountEmailModelDao, AccountEmail, AccountApiException> accountEmailSqlDao = new MockEntityDaoBase();
    private final PersistentBus eventBus;
    private final Clock clock;

    @Inject
    public MockAccountDao(PersistentBus eventBus, Clock clock) {
        this.eventBus = eventBus;
        this.clock = clock;
    }

    public void create(AccountModelDao account, InternalCallContext context) throws AccountApiException {
        super.create((EntityModelDao)account, context);
        try {
            Long accountRecordId = this.getRecordId(account.getId(), (InternalTenantContext)context);
            long tenantRecordId = context == null ? InternalCallContextFactory.INTERNAL_TENANT_RECORD_ID : context.getTenantRecordId();
            this.eventBus.post((BusEvent)new DefaultAccountCreationEvent(new DefaultAccountCreationEvent.DefaultAccountData(account), account.getId(), accountRecordId, Long.valueOf(tenantRecordId), UUID.randomUUID()));
        }
        catch (PersistentBus.EventBusException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void update(AccountModelDao account, InternalCallContext context) {
        super.update((EntityModelDao)account, context);
        AccountModelDao currentAccount = (AccountModelDao)this.getById(account.getId(), (InternalTenantContext)context);
        Long accountRecordId = this.getRecordId(account.getId(), (InternalTenantContext)context);
        long tenantRecordId = context == null ? InternalCallContextFactory.INTERNAL_TENANT_RECORD_ID : context.getTenantRecordId();
        DefaultAccountChangeEvent changeEvent = new DefaultAccountChangeEvent(account.getId(), currentAccount, account, accountRecordId, Long.valueOf(tenantRecordId), UUID.randomUUID(), this.clock.getUTCNow());
        if (changeEvent.hasChanges()) {
            try {
                this.eventBus.post((BusEvent)changeEvent);
            }
            catch (PersistentBus.EventBusException ex) {
                Assert.fail((String)ex.toString());
            }
        }
    }

    public AccountModelDao getAccountByKey(String externalKey, InternalTenantContext context) {
        for (Map accountRow : this.entities.values()) {
            AccountModelDao account = (AccountModelDao)accountRow.values().iterator().next();
            if (!account.getExternalKey().equals(externalKey)) continue;
            return account;
        }
        return null;
    }

    public Pagination<AccountModelDao> searchAccounts(String searchKey, Long offset, Long limit, InternalTenantContext context) {
        LinkedList<AccountModelDao> results = new LinkedList<AccountModelDao>();
        int maxNbRecords = 0;
        for (AccountModelDao account : this.getAll(context)) {
            ++maxNbRecords;
            if (!(account.getName() != null && account.getName().contains(searchKey) || account.getEmail() != null && account.getEmail().contains(searchKey) || account.getExternalKey() != null && account.getExternalKey().contains(searchKey)) && (account.getCompanyName() == null || !account.getCompanyName().contains(searchKey))) continue;
            results.add(account);
        }
        return DefaultPagination.build((Long)offset, (Long)limit, (Integer)maxNbRecords, results);
    }

    public UUID getIdFromKey(String externalKey, InternalTenantContext context) {
        AccountModelDao account = this.getAccountByKey(externalKey, context);
        return account == null ? null : account.getId();
    }

    public void updatePaymentMethod(UUID accountId, UUID paymentMethodId, InternalCallContext context) throws AccountApiException {
        AccountModelDao currentAccountModelDao = (AccountModelDao)this.getById(accountId, (InternalTenantContext)context);
        if (currentAccountModelDao == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{accountId});
        }
        DefaultAccount currentAccount = new DefaultAccount(currentAccountModelDao);
        DefaultMutableAccountData updatedAccount = new DefaultMutableAccountData((AccountData)currentAccount);
        updatedAccount.setPaymentMethodId(paymentMethodId);
        this.update(new AccountModelDao(accountId, (AccountData)updatedAccount), context);
    }

    public void addEmail(AccountEmailModelDao email, InternalCallContext context) {
        try {
            this.accountEmailSqlDao.create((EntityModelDao)email, context);
        }
        catch (BillingExceptionBase billingExceptionBase) {
            Assert.fail((String)billingExceptionBase.toString());
        }
    }

    public void removeEmail(AccountEmailModelDao email, InternalCallContext context) {
        this.accountEmailSqlDao.delete((EntityModelDao)email, context);
    }

    public List<AccountEmailModelDao> getEmailsByAccountId(final UUID accountId, InternalTenantContext context) {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.accountEmailSqlDao.getAll(context), (Predicate)new Predicate<AccountEmailModelDao>(){

            public boolean apply(AccountEmailModelDao input) {
                return input.getAccountId().equals(accountId);
            }
        }));
    }

    public Integer getAccountBCD(UUID accountId, InternalTenantContext context) {
        AccountModelDao account = (AccountModelDao)this.getById(accountId, context);
        return account != null ? account.getBillingCycleDayLocal() : 0;
    }

    public List<AccountModelDao> getAccountsByParentId(final UUID parentAccountId, InternalTenantContext context) {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.accountSqlDao.getAll(context), (Predicate)new Predicate<AccountModelDao>(){

            public boolean apply(AccountModelDao input) {
                return parentAccountId.equals(input.getParentAccountId());
            }
        }));
    }
}

