/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.killbill.billing.GuicyKillbillTestSuiteWithEmbeddedDB;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.account.dao.AccountDao;
import org.killbill.billing.account.glue.TestAccountModuleWithEmbeddedDB;
import org.killbill.billing.util.audit.dao.AuditDao;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.customfield.dao.CustomFieldDao;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.tag.api.user.TagEventBuilder;
import org.killbill.billing.util.tag.dao.TagDao;
import org.killbill.billing.util.tag.dao.TagDefinitionDao;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class AccountTestSuiteWithEmbeddedDB
extends GuicyKillbillTestSuiteWithEmbeddedDB {
    @Inject
    protected AccountDao accountDao;
    @Inject
    protected AccountUserApi accountUserApi;
    @Inject
    protected AuditDao auditDao;
    @Inject
    protected CacheControllerDispatcher controllerDispatcher;
    @Inject
    protected Clock clock;
    @Inject
    protected CustomFieldDao customFieldDao;
    @Inject
    protected PersistentBus bus;
    @Inject
    protected TagDao tagDao;
    @Inject
    protected TagDefinitionDao tagDefinitionDao;
    @Inject
    protected TagEventBuilder tagEventBuilder;
    @Inject
    protected NonEntityDao nonEntityDao;

    @BeforeClass(groups={"slow"})
    protected void beforeClass() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestAccountModuleWithEmbeddedDB(this.configSource)});
        injector.injectMembers((Object)this);
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.controllerDispatcher.clearAll();
        this.bus.start();
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        this.bus.stop();
    }

    protected Account createAccount(AccountData accountData) throws AccountApiException {
        Account account = this.accountUserApi.createAccount(accountData, this.callContext);
        this.refreshCallContext(account.getId());
        return account;
    }
}

