/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.dao;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.user.DefaultAccountChangeEvent;
import org.killbill.billing.account.api.user.DefaultAccountCreationEvent;
import org.killbill.billing.account.dao.AccountDao;
import org.killbill.billing.account.dao.AccountEmailModelDao;
import org.killbill.billing.account.dao.AccountEmailSqlDao;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.account.dao.AccountSqlDao;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.entity.EntityPersistenceException;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationSqlDaoHelper;
import org.killbill.billing.util.entity.dao.EntityDaoBase;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccountDao
extends EntityDaoBase<AccountModelDao, Account, AccountApiException>
implements AccountDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultAccountDao.class);
    private final PersistentBus eventBus;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public DefaultAccountDao(IDBI dbi, PersistentBus eventBus, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, InternalCallContextFactory internalCallContextFactory, NonEntityDao nonEntityDao) {
        super(new EntitySqlDaoTransactionalJdbiWrapper(dbi, clock, cacheControllerDispatcher, nonEntityDao), AccountSqlDao.class);
        this.eventBus = eventBus;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    protected AccountApiException generateAlreadyExistsException(AccountModelDao account, InternalCallContext context) {
        return new AccountApiException(ErrorCode.ACCOUNT_ALREADY_EXISTS, new Object[]{account.getExternalKey()});
    }

    protected void postBusEventFromTransaction(AccountModelDao account, AccountModelDao savedAccount, ChangeType changeType, EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, InternalCallContext context) throws BillingExceptionBase {
        switch (changeType) {
            case INSERT: {
                break;
            }
            default: {
                return;
            }
        }
        Long recordId = ((AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class)).getRecordId(savedAccount.getId().toString(), (InternalTenantContext)context);
        InternalCallContext rehydratedContext = this.internalCallContextFactory.createInternalCallContext(recordId, context);
        DefaultAccountCreationEvent creationEvent = new DefaultAccountCreationEvent(new DefaultAccountCreationEvent.DefaultAccountData(savedAccount), savedAccount.getId(), context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
        try {
            this.eventBus.postFromTransaction((BusEvent)creationEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
        }
        catch (PersistentBus.EventBusException e) {
            log.warn("Failed to post account creation event for account " + savedAccount.getId(), (Throwable)e);
        }
    }

    @Override
    public AccountModelDao getAccountByKey(final String key, final InternalTenantContext context) {
        return (AccountModelDao)((Object)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<AccountModelDao>(){

            public AccountModelDao inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return ((AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class)).getAccountByKey(key, context);
            }
        }));
    }

    @Override
    public Pagination<AccountModelDao> searchAccounts(final String searchKey, final Long offset, Long limit, InternalTenantContext context) {
        return this.paginationHelper.getPagination(AccountSqlDao.class, (DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder)new DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder<AccountModelDao, Account, AccountSqlDao>(){

            public Long getCount(AccountSqlDao accountSqlDao, InternalTenantContext context) {
                return accountSqlDao.getSearchCount(searchKey, String.format("%%%s%%", searchKey), context);
            }

            public Iterator<AccountModelDao> build(AccountSqlDao accountSqlDao, Long limit, InternalTenantContext context) {
                return accountSqlDao.search(searchKey, String.format("%%%s%%", searchKey), offset, limit, context);
            }
        }, offset, limit, context);
    }

    @Override
    public UUID getIdFromKey(final String externalKey, final InternalTenantContext context) throws AccountApiException {
        if (externalKey == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_CANNOT_MAP_NULL_KEY, new Object[]{""});
        }
        return (UUID)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<UUID>(){

            public UUID inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return ((AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class)).getIdFromKey(externalKey, context);
            }
        });
    }

    @Override
    public void update(final AccountModelDao specifiedAccount, final InternalCallContext context) throws AccountApiException {
        this.transactionalSqlDao.execute(AccountApiException.class, (EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws PersistentBus.EventBusException, AccountApiException {
                UUID accountId;
                AccountSqlDao transactional = (AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class);
                AccountModelDao currentAccount = (AccountModelDao)transactional.getById((accountId = specifiedAccount.getId()).toString(), (InternalTenantContext)context);
                if (currentAccount == null) {
                    throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{accountId});
                }
                transactional.update(specifiedAccount, context);
                DefaultAccountChangeEvent changeEvent = new DefaultAccountChangeEvent(accountId, currentAccount, specifiedAccount, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                try {
                    DefaultAccountDao.this.eventBus.postFromTransaction((BusEvent)changeEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
                }
                catch (PersistentBus.EventBusException e) {
                    log.warn("Failed to post account change event for account " + accountId, (Throwable)e);
                }
                return null;
            }
        });
    }

    @Override
    public void updatePaymentMethod(final UUID accountId, final UUID paymentMethodId, final InternalCallContext context) throws AccountApiException {
        this.transactionalSqlDao.execute(AccountApiException.class, (EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws EntityPersistenceException, PersistentBus.EventBusException {
                AccountSqlDao transactional = (AccountSqlDao)entitySqlDaoWrapperFactory.become(AccountSqlDao.class);
                AccountModelDao currentAccount = (AccountModelDao)transactional.getById(accountId.toString(), (InternalTenantContext)context);
                if (currentAccount == null) {
                    throw new EntityPersistenceException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{accountId});
                }
                if (currentAccount.getPaymentMethodId() == null && paymentMethodId == null || currentAccount.getPaymentMethodId() != null && currentAccount.getPaymentMethodId().equals(paymentMethodId)) {
                    return null;
                }
                String thePaymentMethodId = paymentMethodId != null ? paymentMethodId.toString() : null;
                transactional.updatePaymentMethod(accountId.toString(), thePaymentMethodId, context);
                AccountModelDao account = (AccountModelDao)transactional.getById(accountId.toString(), (InternalTenantContext)context);
                DefaultAccountChangeEvent changeEvent = new DefaultAccountChangeEvent(accountId, currentAccount, account, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                try {
                    DefaultAccountDao.this.eventBus.postFromTransaction((BusEvent)changeEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
                }
                catch (PersistentBus.EventBusException e) {
                    log.warn("Failed to post account change event for account " + accountId, (Throwable)e);
                }
                return null;
            }
        });
    }

    @Override
    public void addEmail(final AccountEmailModelDao email, final InternalCallContext context) throws AccountApiException {
        this.transactionalSqlDao.execute(AccountApiException.class, (EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                AccountEmailSqlDao transactional = (AccountEmailSqlDao)entitySqlDaoWrapperFactory.become(AccountEmailSqlDao.class);
                if (transactional.getById(email.getId().toString(), (InternalTenantContext)context) != null) {
                    throw new AccountApiException(ErrorCode.ACCOUNT_EMAIL_ALREADY_EXISTS, new Object[]{email.getId()});
                }
                transactional.create(email, context);
                return null;
            }
        });
    }

    @Override
    public void removeEmail(final AccountEmailModelDao email, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                ((AccountEmailSqlDao)entitySqlDaoWrapperFactory.become(AccountEmailSqlDao.class)).markEmailAsDeleted(email, context);
                return null;
            }
        });
    }

    @Override
    public List<AccountEmailModelDao> getEmailsByAccountId(final UUID accountId, final InternalTenantContext context) {
        return (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<AccountEmailModelDao>>(){

            public List<AccountEmailModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return ((AccountEmailSqlDao)entitySqlDaoWrapperFactory.become(AccountEmailSqlDao.class)).getEmailByAccountId(accountId, context);
            }
        });
    }
}

