/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.user;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultAccountEmail;
import org.killbill.billing.account.dao.AccountDao;
import org.killbill.billing.account.dao.AccountEmailModelDao;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.CallContextFactory;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccountUserApi
implements AccountUserApi {
    private final CallContextFactory callContextFactory;
    private final InternalCallContextFactory internalCallContextFactory;
    private final AccountDao accountDao;

    @Inject
    public DefaultAccountUserApi(CallContextFactory callContextFactory, InternalCallContextFactory internalCallContextFactory, AccountDao accountDao) {
        this.callContextFactory = callContextFactory;
        this.internalCallContextFactory = internalCallContextFactory;
        this.accountDao = accountDao;
    }

    public Account createAccount(AccountData data, CallContext context) throws AccountApiException {
        if (data.getExternalKey() != null && this.getIdFromKey(data.getExternalKey(), (TenantContext)context) != null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_ALREADY_EXISTS, new Object[]{data.getExternalKey()});
        }
        AccountModelDao account = new AccountModelDao(data);
        this.accountDao.create(account, this.internalCallContextFactory.createInternalCallContext(context));
        return new DefaultAccount(account);
    }

    public Account getAccountByKey(String key, TenantContext context) throws AccountApiException {
        AccountModelDao account = this.accountDao.getAccountByKey(key, this.internalCallContextFactory.createInternalTenantContext(context));
        if (account == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_KEY, new Object[]{key});
        }
        return new DefaultAccount(account);
    }

    public Account getAccountById(UUID id, TenantContext context) throws AccountApiException {
        AccountModelDao account = (AccountModelDao)this.accountDao.getById(id, this.internalCallContextFactory.createInternalTenantContext(context));
        if (account == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{id});
        }
        return new DefaultAccount(account);
    }

    public Pagination<Account> searchAccounts(final String searchKey, final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException((Long)limit, (DefaultPaginationHelper.SourcePaginationBuilder)new DefaultPaginationHelper.SourcePaginationBuilder<AccountModelDao, AccountApiException>(){

            public Pagination<AccountModelDao> build() {
                return DefaultAccountUserApi.this.accountDao.searchAccounts(searchKey, offset, limit, DefaultAccountUserApi.this.internalCallContextFactory.createInternalTenantContext(context));
            }
        }, (Function)new Function<AccountModelDao, Account>(){

            public Account apply(AccountModelDao accountModelDao) {
                return new DefaultAccount(accountModelDao);
            }
        });
    }

    public Pagination<Account> getAccounts(final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException((Long)limit, (DefaultPaginationHelper.SourcePaginationBuilder)new DefaultPaginationHelper.SourcePaginationBuilder<AccountModelDao, AccountApiException>(){

            public Pagination<AccountModelDao> build() {
                return DefaultAccountUserApi.this.accountDao.get(offset, limit, DefaultAccountUserApi.this.internalCallContextFactory.createInternalTenantContext(context));
            }
        }, (Function)new Function<AccountModelDao, Account>(){

            public Account apply(AccountModelDao accountModelDao) {
                return new DefaultAccount(accountModelDao);
            }
        });
    }

    public UUID getIdFromKey(String externalKey, TenantContext context) throws AccountApiException {
        return this.accountDao.getIdFromKey(externalKey, this.internalCallContextFactory.createInternalTenantContext(context));
    }

    public void updateAccount(Account account, CallContext context) throws AccountApiException {
        this.updateAccount(account.getId(), (AccountData)account, context);
    }

    public void updateAccount(UUID accountId, AccountData accountData, CallContext context) throws AccountApiException {
        Account currentAccount = this.getAccountById(accountId, (TenantContext)context);
        if (currentAccount == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{accountId});
        }
        this.updateAccount(currentAccount, accountData, context);
    }

    public void updateAccount(String externalKey, AccountData accountData, CallContext context) throws AccountApiException {
        Account currentAccount = this.getAccountByKey(externalKey, (TenantContext)context);
        if (currentAccount == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_KEY, new Object[]{externalKey});
        }
        this.updateAccount(currentAccount, accountData, context);
    }

    private void updateAccount(Account currentAccount, AccountData accountData, CallContext context) throws AccountApiException {
        DefaultAccount updatedAccount = new DefaultAccount(currentAccount.getId(), accountData);
        AccountModelDao accountToUpdate = new AccountModelDao(currentAccount.getId(), (AccountData)updatedAccount.mergeWithDelegate(currentAccount));
        this.accountDao.update(accountToUpdate, this.internalCallContextFactory.createInternalCallContext(accountToUpdate.getId(), context));
    }

    public List<AccountEmail> getEmails(UUID accountId, TenantContext context) {
        return ImmutableList.copyOf((Collection)Collections2.transform(this.accountDao.getEmailsByAccountId(accountId, this.internalCallContextFactory.createInternalTenantContext(context)), (Function)new Function<AccountEmailModelDao, AccountEmail>(){

            public AccountEmail apply(AccountEmailModelDao input) {
                return new DefaultAccountEmail(input);
            }
        }));
    }

    public void addEmail(UUID accountId, AccountEmail email, CallContext context) throws AccountApiException {
        this.accountDao.addEmail(new AccountEmailModelDao(email), this.internalCallContextFactory.createInternalCallContext(accountId, context));
    }

    public void removeEmail(UUID accountId, AccountEmail email, CallContext context) {
        this.accountDao.removeEmail(new AccountEmailModelDao(email, false), this.internalCallContextFactory.createInternalCallContext(accountId, context));
    }
}

