/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.svcs;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultAccountEmail;
import org.killbill.billing.account.dao.AccountDao;
import org.killbill.billing.account.dao.AccountEmailModelDao;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccountInternalApi
implements AccountInternalApi {
    private final AccountDao accountDao;

    @Inject
    public DefaultAccountInternalApi(AccountDao accountDao) {
        this.accountDao = accountDao;
    }

    public Account getAccountById(UUID accountId, InternalTenantContext context) throws AccountApiException {
        AccountModelDao account = (AccountModelDao)this.accountDao.getById(accountId, context);
        if (account == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{accountId});
        }
        return new DefaultAccount(account);
    }

    public Account getAccountByRecordId(Long recordId, InternalTenantContext context) throws AccountApiException {
        AccountModelDao accountModelDao = this.getAccountModelDaoByRecordId(recordId, context);
        return new DefaultAccount(accountModelDao);
    }

    public void updateAccount(String externalKey, AccountData accountData, InternalCallContext context) throws AccountApiException {
        Account currentAccount = this.getAccountByKey(externalKey, (InternalTenantContext)context);
        if (currentAccount == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_KEY, new Object[]{externalKey});
        }
        DefaultAccount updatedAccount = new DefaultAccount(currentAccount.getId(), accountData);
        AccountModelDao accountToUpdate = new AccountModelDao(currentAccount.getId(), (AccountData)updatedAccount.mergeWithDelegate(currentAccount));
        this.accountDao.update(accountToUpdate, context);
    }

    public List<AccountEmail> getEmails(UUID accountId, InternalTenantContext context) {
        return ImmutableList.copyOf((Collection)Collections2.transform(this.accountDao.getEmailsByAccountId(accountId, context), (Function)new Function<AccountEmailModelDao, AccountEmail>(){

            public AccountEmail apply(AccountEmailModelDao input) {
                return new DefaultAccountEmail(input);
            }
        }));
    }

    public Account getAccountByKey(String key, InternalTenantContext context) throws AccountApiException {
        AccountModelDao accountModelDao = this.accountDao.getAccountByKey(key, context);
        if (accountModelDao == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_KEY, new Object[]{key});
        }
        return new DefaultAccount(accountModelDao);
    }

    public void removePaymentMethod(UUID accountId, InternalCallContext context) throws AccountApiException {
        this.updatePaymentMethod(accountId, null, context);
    }

    public void updatePaymentMethod(UUID accountId, UUID paymentMethodId, InternalCallContext context) throws AccountApiException {
        this.accountDao.updatePaymentMethod(accountId, paymentMethodId, context);
    }

    public UUID getByRecordId(Long recordId, InternalTenantContext context) throws AccountApiException {
        AccountModelDao accountModelDao = this.getAccountModelDaoByRecordId(recordId, context);
        return accountModelDao.getId();
    }

    private AccountModelDao getAccountModelDaoByRecordId(Long recordId, InternalTenantContext context) throws AccountApiException {
        AccountModelDao accountModelDao = (AccountModelDao)this.accountDao.getByRecordId(recordId, context);
        if (accountModelDao == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_RECORD_ID, new Object[]{recordId});
        }
        return accountModelDao;
    }
}

