/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.DefaultMutableAccountData;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.entity.EntityBase;

public class DefaultAccount
extends EntityBase
implements Account {
    public static final String DEFAULT_STRING_VALUE = "";
    public static final Integer DEFAULT_INTEGER_VALUE = 0;
    public static final Currency DEFAULT_CURRENCY_VALUE = Currency.USD;
    public static final DateTimeZone DEFAULT_TIMEZONE_VALUE = DateTimeZone.UTC;
    public static final Boolean DEFAULT_MIGRATED_VALUE = false;
    public static final Boolean DEFAULT_NOTIFIED_FOR_INVOICES_VALUE = false;
    private final String externalKey;
    private final String email;
    private final String name;
    private final Integer firstNameLength;
    private final Currency currency;
    private final Integer billCycleDayLocal;
    private final UUID paymentMethodId;
    private final DateTimeZone timeZone;
    private final String locale;
    private final String address1;
    private final String address2;
    private final String companyName;
    private final String city;
    private final String stateOrProvince;
    private final String country;
    private final String postalCode;
    private final String phone;
    private final Boolean isMigrated;
    private final Boolean isNotifiedForInvoices;

    public DefaultAccount(UUID id, AccountData data) {
        this(id, data.getExternalKey(), data.getEmail(), data.getName(), data.getFirstNameLength(), data.getCurrency(), data.getBillCycleDayLocal(), data.getPaymentMethodId(), data.getTimeZone(), data.getLocale(), data.getAddress1(), data.getAddress2(), data.getCompanyName(), data.getCity(), data.getStateOrProvince(), data.getCountry(), data.getPostalCode(), data.getPhone(), data.isMigrated(), data.isNotifiedForInvoices());
    }

    public DefaultAccount(UUID id, String externalKey, String email, String name, Integer firstNameLength, Currency currency, Integer billCycleDayLocal, UUID paymentMethodId, DateTimeZone timeZone, String locale, String address1, String address2, String companyName, String city, String stateOrProvince, String country, String postalCode, String phone, Boolean isMigrated, Boolean isNotifiedForInvoices) {
        this(id, null, null, externalKey, email, name, firstNameLength, currency, billCycleDayLocal, paymentMethodId, timeZone, locale, address1, address2, companyName, city, stateOrProvince, country, postalCode, phone, isMigrated, isNotifiedForInvoices);
    }

    public DefaultAccount(UUID id, @Nullable DateTime createdDate, @Nullable DateTime updatedDate, String externalKey, String email, String name, Integer firstNameLength, Currency currency, Integer billCycleDayLocal, UUID paymentMethodId, DateTimeZone timeZone, String locale, String address1, String address2, String companyName, String city, String stateOrProvince, String country, String postalCode, String phone, Boolean isMigrated, Boolean isNotifiedForInvoices) {
        super(id, createdDate, updatedDate);
        this.externalKey = externalKey;
        this.email = email;
        this.name = name;
        this.firstNameLength = firstNameLength;
        this.currency = currency;
        this.billCycleDayLocal = billCycleDayLocal;
        this.paymentMethodId = paymentMethodId;
        this.timeZone = timeZone;
        this.locale = locale;
        this.address1 = address1;
        this.address2 = address2;
        this.companyName = companyName;
        this.city = city;
        this.stateOrProvince = stateOrProvince;
        this.postalCode = postalCode;
        this.country = country;
        this.phone = phone;
        this.isMigrated = isMigrated;
        this.isNotifiedForInvoices = isNotifiedForInvoices;
    }

    public DefaultAccount(AccountModelDao accountModelDao) {
        this(accountModelDao.getId(), accountModelDao.getCreatedDate(), accountModelDao.getUpdatedDate(), accountModelDao.getExternalKey(), accountModelDao.getEmail(), accountModelDao.getName(), accountModelDao.getFirstNameLength(), accountModelDao.getCurrency(), accountModelDao.getBillingCycleDayLocal(), accountModelDao.getPaymentMethodId(), accountModelDao.getTimeZone(), accountModelDao.getLocale(), accountModelDao.getAddress1(), accountModelDao.getAddress2(), accountModelDao.getCompanyName(), accountModelDao.getCity(), accountModelDao.getStateOrProvince(), accountModelDao.getCountry(), accountModelDao.getPostalCode(), accountModelDao.getPhone(), accountModelDao.getMigrated(), accountModelDao.getIsNotifiedForInvoices());
    }

    public String getExternalKey() {
        return (String)Objects.firstNonNull((Object)this.externalKey, (Object)DEFAULT_STRING_VALUE);
    }

    public String getName() {
        return (String)Objects.firstNonNull((Object)this.name, (Object)DEFAULT_STRING_VALUE);
    }

    public String getEmail() {
        return (String)Objects.firstNonNull((Object)this.email, (Object)DEFAULT_STRING_VALUE);
    }

    public Integer getFirstNameLength() {
        return (Integer)Objects.firstNonNull((Object)this.firstNameLength, (Object)DEFAULT_INTEGER_VALUE);
    }

    public Currency getCurrency() {
        return (Currency)Objects.firstNonNull((Object)this.currency, (Object)DEFAULT_CURRENCY_VALUE);
    }

    public Integer getBillCycleDayLocal() {
        return (Integer)Objects.firstNonNull((Object)this.billCycleDayLocal, (Object)DEFAULT_INTEGER_VALUE);
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public DateTimeZone getTimeZone() {
        return (DateTimeZone)Objects.firstNonNull((Object)this.timeZone, (Object)DEFAULT_TIMEZONE_VALUE);
    }

    public String getLocale() {
        return (String)Objects.firstNonNull((Object)this.locale, (Object)DEFAULT_STRING_VALUE);
    }

    public String getAddress1() {
        return (String)Objects.firstNonNull((Object)this.address1, (Object)DEFAULT_STRING_VALUE);
    }

    public String getAddress2() {
        return (String)Objects.firstNonNull((Object)this.address2, (Object)DEFAULT_STRING_VALUE);
    }

    public String getCompanyName() {
        return (String)Objects.firstNonNull((Object)this.companyName, (Object)DEFAULT_STRING_VALUE);
    }

    public String getCity() {
        return (String)Objects.firstNonNull((Object)this.city, (Object)DEFAULT_STRING_VALUE);
    }

    public String getStateOrProvince() {
        return (String)Objects.firstNonNull((Object)this.stateOrProvince, (Object)DEFAULT_STRING_VALUE);
    }

    public String getPostalCode() {
        return (String)Objects.firstNonNull((Object)this.postalCode, (Object)DEFAULT_STRING_VALUE);
    }

    public String getCountry() {
        return (String)Objects.firstNonNull((Object)this.country, (Object)DEFAULT_STRING_VALUE);
    }

    public Boolean isMigrated() {
        return (Boolean)Objects.firstNonNull((Object)this.isMigrated, (Object)DEFAULT_MIGRATED_VALUE);
    }

    public Boolean isNotifiedForInvoices() {
        return (Boolean)Objects.firstNonNull((Object)this.isNotifiedForInvoices, (Object)DEFAULT_NOTIFIED_FOR_INVOICES_VALUE);
    }

    public String getPhone() {
        return (String)Objects.firstNonNull((Object)this.phone, (Object)DEFAULT_STRING_VALUE);
    }

    public MutableAccountData toMutableAccountData() {
        return new DefaultMutableAccountData((AccountData)this);
    }

    public Account mergeWithDelegate(Account currentAccount) {
        DefaultMutableAccountData accountData = new DefaultMutableAccountData((AccountData)this);
        if (this.externalKey != null && currentAccount.getExternalKey() != null && !currentAccount.getExternalKey().equals(this.externalKey)) {
            throw new IllegalArgumentException(String.format("Killbill doesn't support updating the account external key yet: new=%s, current=%s", this.externalKey, currentAccount.getExternalKey()));
        }
        accountData.setExternalKey(currentAccount.getExternalKey());
        if (this.currency != null && currentAccount.getCurrency() != null && !currentAccount.getCurrency().equals((Object)this.currency)) {
            throw new IllegalArgumentException(String.format("Killbill doesn't support updating the account currency yet: new=%s, current=%s", this.currency, currentAccount.getCurrency()));
        }
        accountData.setCurrency(currentAccount.getCurrency());
        if (this.billCycleDayLocal != null && this.billCycleDayLocal != 0 && currentAccount.getBillCycleDayLocal() != 0 && !this.billCycleDayLocal.equals(currentAccount.getBillCycleDayLocal())) {
            throw new IllegalArgumentException(String.format("Killbill doesn't support updating the account BCD yet: new=%s, current=%s", this.billCycleDayLocal, currentAccount.getBillCycleDayLocal()));
        }
        if (this.billCycleDayLocal != null && this.billCycleDayLocal != 0) {
            accountData.setBillCycleDayLocal(this.billCycleDayLocal.intValue());
        } else {
            accountData.setBillCycleDayLocal(currentAccount.getBillCycleDayLocal().intValue());
        }
        accountData.setEmail((String)Objects.firstNonNull((Object)this.email, (Object)currentAccount.getEmail()));
        accountData.setName((String)Objects.firstNonNull((Object)this.name, (Object)currentAccount.getName()));
        accountData.setFirstNameLength(((Integer)Objects.firstNonNull((Object)this.firstNameLength, (Object)currentAccount.getFirstNameLength())).intValue());
        accountData.setPaymentMethodId((UUID)Optional.fromNullable((Object)this.paymentMethodId).or(Optional.fromNullable((Object)currentAccount.getPaymentMethodId())).orNull());
        accountData.setTimeZone((DateTimeZone)Objects.firstNonNull((Object)this.timeZone, (Object)currentAccount.getTimeZone()));
        accountData.setLocale((String)Objects.firstNonNull((Object)this.locale, (Object)currentAccount.getLocale()));
        accountData.setAddress1((String)Objects.firstNonNull((Object)this.address1, (Object)currentAccount.getAddress1()));
        accountData.setAddress2((String)Objects.firstNonNull((Object)this.address2, (Object)currentAccount.getAddress2()));
        accountData.setCompanyName((String)Objects.firstNonNull((Object)this.companyName, (Object)currentAccount.getCompanyName()));
        accountData.setCity((String)Objects.firstNonNull((Object)this.city, (Object)currentAccount.getCity()));
        accountData.setStateOrProvince((String)Objects.firstNonNull((Object)this.stateOrProvince, (Object)currentAccount.getStateOrProvince()));
        accountData.setCountry((String)Objects.firstNonNull((Object)this.country, (Object)currentAccount.getCountry()));
        accountData.setPostalCode((String)Objects.firstNonNull((Object)this.postalCode, (Object)currentAccount.getPostalCode()));
        accountData.setPhone((String)Objects.firstNonNull((Object)this.phone, (Object)currentAccount.getPhone()));
        accountData.setIsMigrated(((Boolean)Objects.firstNonNull((Object)this.isMigrated, (Object)currentAccount.isMigrated())).booleanValue());
        accountData.setIsNotifiedForInvoices(((Boolean)Objects.firstNonNull((Object)this.isNotifiedForInvoices, (Object)currentAccount.isNotifiedForInvoices())).booleanValue());
        return new DefaultAccount(currentAccount.getId(), (AccountData)accountData);
    }

    public String toString() {
        return "DefaultAccount [externalKey=" + this.externalKey + ", email=" + this.email + ", name=" + this.name + ", firstNameLength=" + this.firstNameLength + ", phone=" + this.phone + ", currency=" + this.currency + ", billCycleDayLocal=" + this.billCycleDayLocal + ", paymentMethodId=" + this.paymentMethodId + ", timezone=" + this.timeZone + ", locale=" + this.locale + ", address1=" + this.address1 + ", address2=" + this.address2 + ", companyName=" + this.companyName + ", city=" + this.city + ", stateOrProvince=" + this.stateOrProvince + ", postalCode=" + this.postalCode + ", country=" + this.country + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultAccount that = (DefaultAccount)((Object)o);
        if (this.billCycleDayLocal != null ? !this.billCycleDayLocal.equals(that.billCycleDayLocal) : that.billCycleDayLocal != null) {
            return false;
        }
        if (this.address1 != null ? !this.address1.equals(that.address1) : that.address1 != null) {
            return false;
        }
        if (this.address2 != null ? !this.address2.equals(that.address2) : that.address2 != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(that.city) : that.city != null) {
            return false;
        }
        if (this.companyName != null ? !this.companyName.equals(that.companyName) : that.companyName != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.firstNameLength != null ? !this.firstNameLength.equals(that.firstNameLength) : that.firstNameLength != null) {
            return false;
        }
        if (this.isMigrated != null ? !this.isMigrated.equals(that.isMigrated) : that.isMigrated != null) {
            return false;
        }
        if (this.isNotifiedForInvoices != null ? !this.isNotifiedForInvoices.equals(that.isNotifiedForInvoices) : that.isNotifiedForInvoices != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.phone != null ? !this.phone.equals(that.phone) : that.phone != null) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(that.postalCode) : that.postalCode != null) {
            return false;
        }
        if (this.stateOrProvince != null ? !this.stateOrProvince.equals(that.stateOrProvince) : that.stateOrProvince != null) {
            return false;
        }
        return !(this.timeZone != null ? !this.timeZone.equals((Object)that.timeZone) : that.timeZone != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.firstNameLength != null ? this.firstNameLength.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + this.billCycleDayLocal;
        result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.address1 != null ? this.address1.hashCode() : 0);
        result = 31 * result + (this.address2 != null ? this.address2.hashCode() : 0);
        result = 31 * result + (this.companyName != null ? this.companyName.hashCode() : 0);
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.stateOrProvince != null ? this.stateOrProvince.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
        result = 31 * result + (this.isMigrated != null ? this.isMigrated.hashCode() : 0);
        result = 31 * result + (this.isNotifiedForInvoices != null ? this.isNotifiedForInvoices.hashCode() : 0);
        return result;
    }
}

