/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.util.StringUtils;

public class FormURLGenerator {
    protected static final String KIE_WB_GWT_MODULE = "org.kie.workbench.KIEWebapp/KIEWebapp.html";
    protected static final String FORM_PERSPECTIVE = "FormDisplayPerspective";

    public String generateFormProcessURL(String baseURL, String processId, String deploymentId, String opener, Map<String, List<String>> params) {
        if (StringUtils.isEmpty((CharSequence)baseURL) || StringUtils.isEmpty((CharSequence)processId) || StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)opener)) {
            return "";
        }
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("processId", processId);
        urlParams.put("domainId", deploymentId);
        urlParams.put("opener", opener);
        return this.generateURL(baseURL, urlParams);
    }

    public String generateFormTaskURL(String baseURL, long taskId, String opener, Map<String, List<String>> params) {
        if (StringUtils.isEmpty((CharSequence)baseURL) || taskId < 0L || StringUtils.isEmpty((CharSequence)opener)) {
            return "";
        }
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("taskId", String.valueOf(taskId));
        urlParams.put("opener", opener);
        return this.generateURL(baseURL, urlParams);
    }

    protected String generateURL(String baseURL, Map<String, String> params) {
        StringBuilder resultURL = new StringBuilder();
        if (baseURL.contains("/rest/")) {
            resultURL.append(baseURL.substring(0, baseURL.indexOf("/rest/"))).append("/");
        } else {
            resultURL.append(baseURL);
        }
        resultURL.append(KIE_WB_GWT_MODULE).append("?perspective=").append(FORM_PERSPECTIVE).append("&standalone=true");
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                resultURL.append("&");
                resultURL.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return resultURL.toString();
    }
}

