/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.async.cmd;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.jbpm.executor.cdi.CDIUtils;
import org.jbpm.kie.services.api.Kjar;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.kie.internal.deployment.DeploymentService;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.internal.executor.api.Command;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutionResults;
import org.kie.remote.services.rest.async.JobResultManager;
import org.kie.remote.services.rest.async.cmd.JobType;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentCmd
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentCmd.class);
    public static final String DEPLOYMENT_UNIT = "DeploymentUnit";
    public static final String JOB_TYPE = "JobType";
    public static final String JOB_ID = "JobId";

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        DeploymentService deploymentService = this.getDeploymentService(ctx);
        KModuleDeploymentUnit deploymentUnit = (KModuleDeploymentUnit)ctx.getData(DEPLOYMENT_UNIT);
        JobType jobType = (JobType)((Object)ctx.getData(JOB_TYPE));
        String deploymentId = deploymentUnit.getIdentifier();
        JobResultManager jobResultMgr = this.getJobManager(ctx);
        String jobId = (String)ctx.getData(JOB_ID);
        JaxbDeploymentJobResult jobResult = jobResultMgr.getJob(jobId);
        boolean success = false;
        switch (jobType) {
            case DEPLOY: {
                try {
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYING);
                    deploymentService.deploy((DeploymentUnit)deploymentUnit);
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED);
                    jobResult.setSuccess(Boolean.valueOf(true));
                    logger.debug("Deployment unit [{}] deployed", (Object)deploymentId);
                    success = true;
                }
                catch (Exception e) {
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOY_FAILED);
                    jobResult.setSuccess(Boolean.valueOf(false));
                    logger.error("Unable to deploy [{}]", (Object)deploymentId, (Object)e);
                }
                break;
            }
            case UNDEPLOY: {
                try {
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYING);
                    deploymentService.undeploy((DeploymentUnit)deploymentUnit);
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYED);
                    logger.debug("Deployment unit [{}] undeployed", (Object)deploymentId);
                    jobResult.setSuccess(Boolean.valueOf(false));
                    success = true;
                }
                catch (Exception e) {
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOY_FAILED);
                    jobResult.setSuccess(Boolean.valueOf(false));
                    logger.error("Unable to undeploy [{}]", (Object)deploymentId, (Object)e);
                }
                break;
            }
            default: {
                logger.error("Unknown " + JobType.class.getSimpleName() + " type (" + jobType.toString() + "), not taking any action");
            }
        }
        ExecutionResults results = new ExecutionResults();
        results.setData("Result", (Object)success);
        return results;
    }

    private DeploymentService getDeploymentService(CommandContext ctx) throws Exception {
        BeanManager beanManager = this.getBeanManager();
        return (DeploymentService)CDIUtils.createBean(DeploymentService.class, (BeanManager)beanManager, (Annotation[])new Annotation[]{new AnnotationLiteral<Kjar>(){}});
    }

    private JobResultManager getJobManager(CommandContext ctx) throws Exception {
        BeanManager beanManager = this.getBeanManager();
        return (JobResultManager)CDIUtils.createBean(JobResultManager.class, (BeanManager)beanManager, (Annotation[])new Annotation[0]);
    }

    private BeanManager getBeanManager() {
        return BeanManagerProvider.getInstance().getBeanManager();
    }
}

