/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.GetWorkItemCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.process.instance.WorkItem;
import org.jboss.resteasy.spi.BadRequestException;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.ClearHistoryLogsCommand;
import org.jbpm.process.audit.command.FindActiveProcessInstancesCommand;
import org.jbpm.process.audit.command.FindNodeInstancesCommand;
import org.jbpm.process.audit.command.FindProcessInstanceCommand;
import org.jbpm.process.audit.command.FindProcessInstancesCommand;
import org.jbpm.process.audit.command.FindSubProcessInstancesCommand;
import org.jbpm.process.audit.command.FindVariableInstancesByNameCommand;
import org.jbpm.process.audit.command.FindVariableInstancesCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceListResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbWorkItem;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.remote.exception.KieRemoteServicesPreConditionException;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.rest.RestProcessRequestBean;
import org.kie.services.remote.util.Paginator;

@Path(value="/runtime/{id: [a-zA-Z0-9-:\\.]+}")
@RequestScoped
public class RuntimeResource
extends ResourceBase {
    @Context
    private HttpHeaders headers;
    @Context
    private HttpServletRequest request;
    @Context
    private Request restRequest;
    @Inject
    private RestProcessRequestBean processRequestBean;
    @PathParam(value="id")
    private String deploymentId;

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/execute")
    public JaxbCommandsResponse execute(JaxbCommandsRequest cmdsRequest) {
        return RuntimeResource.restProcessJaxbCommandsRequest(cmdsRequest, this.processRequestBean);
    }

    @POST
    @Path(value="/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public Response process_defId_start(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> requestParams = RuntimeResource.getRequestParams(this.request);
        String oper = this.getRelativePath(this.request);
        Map<String, Object> params = RuntimeResource.extractMapFromParams(requestParams, oper);
        StartProcessCommand cmd = new StartProcessCommand(processId, params);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, null, "Unable to start process with process definition id '" + processId + "'");
        JaxbProcessInstanceResponse responseObj = new JaxbProcessInstanceResponse((ProcessInstance)result, this.request);
        return RuntimeResource.createCorrectVariant(responseObj, this.headers);
    }

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}")
    public Response process_instance_procInstId(@PathParam(value="procInstId") Long procInstId) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(procInstId);
        cmd.setReadOnly(true);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, "Unable to get process instance " + procInstId);
        JaxbProcessInstanceResponse responseObj = null;
        if (result != null) {
            responseObj = new JaxbProcessInstanceResponse((ProcessInstance)result);
            return RuntimeResource.createCorrectVariant(responseObj, this.headers);
        }
        throw new BadRequestException("Unable to retrieve process instance " + procInstId + " which may have been completed. Please see the history operations.");
    }

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/abort")
    public Response process_instance_procInstId_abort(@PathParam(value="procInstId") Long procInstId) {
        AbortProcessInstanceCommand cmd = new AbortProcessInstanceCommand();
        cmd.setProcessInstanceId(procInstId);
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, "Unable to abort process instance " + procInstId);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.request), this.headers);
    }

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/signal")
    public Response process_instance_procInstId_signal(@PathParam(value="procInstId") Long procInstId) {
        String oper = this.getRelativePath(this.request);
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String eventType = RuntimeResource.getStringParam("signal", true, params, oper);
        Object event = RuntimeResource.getObjectParam("event", false, params, oper);
        SignalEventCommand cmd = new SignalEventCommand(procInstId.longValue(), eventType, event);
        String errorMsg = "Unable to signal process instance";
        errorMsg = eventType == null ? errorMsg + " with empty signal" : errorMsg + " with signal type '" + eventType + "'";
        if (event != null) {
            errorMsg = errorMsg + " and event '" + event + "'";
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, errorMsg);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.request), this.headers);
    }

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}/variables")
    public Response process_instance_procInstId_variables(@PathParam(value="procInstId") Long procInstId) {
        Map<String, String> vars = this.getVariables(procInstId);
        return RuntimeResource.createCorrectVariant(new JaxbVariablesResponse(vars, this.request), this.headers);
    }

    @POST
    @Path(value="/signal")
    public Response signal() {
        String oper = this.getRelativePath(this.request);
        Map<String, List<String>> requestParams = RuntimeResource.getRequestParams(this.request);
        String eventType = RuntimeResource.getStringParam("signal", true, requestParams, oper);
        Object event = RuntimeResource.getObjectParam("event", false, requestParams, oper);
        String errorMsg = "Unable to send signal '" + eventType + "'";
        if (event != null) {
            errorMsg = errorMsg + " with event '" + event + "'";
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)new SignalEventCommand(eventType, event), this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, requestParams, oper, true), errorMsg);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.request), this.headers);
    }

    @GET
    @Path(value="/workitem/{workItemId: [0-9-]+}")
    public Response workitem_workItemId(@PathParam(value="workItemId") Long workItemId) {
        String oper = this.getRelativePath(this.request);
        WorkItem workItem = (WorkItem)this.processRequestBean.doKieSessionOperation((Command<?>)new GetWorkItemCommand(workItemId.longValue()), this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, RuntimeResource.getRequestParams(this.request), oper, true), "Unable to get work item " + workItemId);
        return RuntimeResource.createCorrectVariant(new JaxbWorkItem((org.kie.api.runtime.process.WorkItem)workItem), this.headers);
    }

    @POST
    @Path(value="/workitem/{workItemId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public Response worktiem_workItemId_oper(@PathParam(value="workItemId") Long workItemId, @PathParam(value="oper") String operation) {
        String oper = this.getRelativePath(this.request);
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        CompleteWorkItemCommand cmd = null;
        if ("complete".equalsIgnoreCase(operation.trim())) {
            Map<String, Object> results = RuntimeResource.extractMapFromParams(params, operation);
            cmd = new CompleteWorkItemCommand(workItemId.longValue(), results);
        } else if ("abort".equalsIgnoreCase(operation.toLowerCase())) {
            cmd = new AbortWorkItemCommand(workItemId.longValue());
        } else {
            throw new BadRequestException("Unsupported operation: " + oper);
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, params, oper, true), "Unable to " + operation + " work item " + workItemId);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.request), this.headers);
    }

    @POST
    @Path(value="/history/clear")
    public Response history_clear() {
        String oper = this.getRelativePath(this.request);
        this.processRequestBean.doKieSessionOperation((Command<?>)new ClearHistoryLogsCommand(), this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, RuntimeResource.getRequestParams(this.request), oper, true), "Unable to clear process instance logs");
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.request), this.headers);
    }

    @GET
    @Path(value="/history/instances")
    public Response history_instance() {
        String oper = this.getRelativePath(this.request);
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params, oper);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new FindProcessInstancesCommand(), this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, params, oper, true), "Unable to get process instance logs");
        List results = (List)result;
        results = new Paginator().paginate(pageInfo, results);
        return RuntimeResource.createCorrectVariant(new JaxbHistoryLogList(results), this.headers);
    }

    @GET
    @Path(value="/history/instance/{procInstId: [0-9]+}")
    public Response history_instance_procInstId(@PathParam(value="procInstId") long procInstId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String oper = this.getRelativePath(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params, oper);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new FindProcessInstanceCommand(procInstId), this.deploymentId, procInstId, "Unable to get process instance logs for process instance " + procInstId);
        ProcessInstanceLog procInstLog = (ProcessInstanceLog)result;
        List<Object> logList = new ArrayList<ProcessInstanceLog>();
        logList.add(procInstLog);
        logList = new Paginator<ProcessInstanceLog>().paginate(pageInfo, logList);
        return RuntimeResource.createCorrectVariant(new JaxbHistoryLogList(logList), this.headers);
    }

    @GET
    @Path(value="/history/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}")
    public Response history_instance_procInstid_oper(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation) {
        String errorMsg;
        FindSubProcessInstancesCommand cmd;
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String oper = this.getRelativePath(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params, oper);
        if ("child".equalsIgnoreCase(operation)) {
            cmd = new FindSubProcessInstancesCommand(procInstId.longValue());
            errorMsg = "Unable to get child process instance logs for process instance " + procInstId;
        } else if ("node".equalsIgnoreCase(operation)) {
            cmd = new FindNodeInstancesCommand(procInstId.longValue());
            errorMsg = "Unable to get node instance logs for process instance " + procInstId;
        } else if ("variable".equalsIgnoreCase(operation)) {
            cmd = new FindVariableInstancesCommand(procInstId.longValue());
            errorMsg = "Unable to get variable instance logs for process instance " + procInstId;
        } else {
            throw new BadRequestException("Unsupported operation: " + oper);
        }
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, errorMsg);
        List varInstLogList = (List)result;
        varInstLogList = new Paginator().paginate(pageInfo, varInstLogList);
        JaxbHistoryLogList resultList = new JaxbHistoryLogList(varInstLogList);
        return RuntimeResource.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/history/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}/{logId: [a-zA-Z0-9-:\\.]+}")
    public Response history_instance_procInstId_oper_logId(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation, @PathParam(value="logId") String logId) {
        String errorMsg;
        FindNodeInstancesCommand cmd;
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String oper = this.getRelativePath(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params, oper);
        if ("node".equalsIgnoreCase(operation)) {
            cmd = new FindNodeInstancesCommand(procInstId.longValue(), logId);
            errorMsg = "Unable to get node instance logs for node '" + logId + "' in process instance " + procInstId;
        } else if ("variable".equalsIgnoreCase(operation)) {
            cmd = new FindVariableInstancesCommand(procInstId.longValue(), logId);
            errorMsg = "Unable to get variable instance logs for variable '" + logId + "' in process instance " + procInstId;
        } else {
            throw new BadRequestException("Unsupported operation: " + oper);
        }
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, errorMsg);
        List varInstLogList = (List)result;
        varInstLogList = new Paginator().paginate(pageInfo, varInstLogList);
        JaxbHistoryLogList resultList = new JaxbHistoryLogList(varInstLogList);
        return RuntimeResource.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/history/process/{processDefId: [a-zA-Z0-9-:\\.]+}")
    public Response history_process_procDefId(@PathParam(value="processDefId") String processId) {
        Object result;
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        Number statusParam = RuntimeResource.getNumberParam("status", false, params, this.getRelativePath(this.request), false);
        String oper = this.getRelativePath(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params, oper);
        if (statusParam != null) {
            Object cmd = statusParam.intValue() == 1 ? new FindActiveProcessInstancesCommand(processId) : new FindProcessInstancesCommand(processId);
            result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, params, oper, true), "Unable to get process instance logs for process '" + processId + "'");
        } else {
            result = this.processRequestBean.doKieSessionOperation((Command<?>)new FindProcessInstancesCommand(processId), this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, params, oper, true), "Unable to get process instance logs for process '" + processId + "'");
        }
        List procInstLogList = (List)result;
        if (statusParam != null && !statusParam.equals(1)) {
            ArrayList<ProcessInstanceLog> filteredProcLogList = new ArrayList<ProcessInstanceLog>();
            for (int i = 0; i < procInstLogList.size() && filteredProcLogList.size() < pageInfo[PAGE_NUM] * pageInfo[PAGE_SIZE]; ++i) {
                ProcessInstanceLog procLog = (ProcessInstanceLog)procInstLogList.get(i);
                if (!procLog.getStatus().equals(statusParam.intValue())) continue;
                filteredProcLogList.add(procLog);
            }
        }
        procInstLogList = new Paginator().paginate(pageInfo, procInstLogList);
        return RuntimeResource.createCorrectVariant(new JaxbHistoryLogList(procInstLogList), this.headers);
    }

    @GET
    @Path(value="/history/variable/{varId: [a-zA-Z0-9-:\\.]+}")
    public Response history_variable_varId(@PathParam(value="varId") String variableId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String oper = this.getRelativePath(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params, oper);
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, null, params, oper);
        varLogList = new Paginator<VariableInstanceLog>().paginate(pageInfo, varLogList);
        return RuntimeResource.createCorrectVariant(new JaxbHistoryLogList(varLogList), this.headers);
    }

    @GET
    @Path(value="/history/variable/{varId: [a-zA-Z0-9-:\\.]+}/value/{value: [a-zA-Z0-9-:\\.]+}")
    public Response history_variable_varId_value_valueVal(@PathParam(value="varId") String variableId, @PathParam(value="value") String value) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String oper = this.getRelativePath(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params, oper);
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, value, params, oper);
        varLogList = new Paginator<VariableInstanceLog>().paginate(pageInfo, varLogList);
        return RuntimeResource.createCorrectVariant(new JaxbHistoryLogList(varLogList), this.headers);
    }

    @GET
    @Path(value="/history/variable/{varId: [a-zA-Z0-9-:\\.]+}/instances")
    public Response history_variable_varId_instances(@PathParam(value="varId") String variableId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String oper = this.getRelativePath(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params, oper);
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, null, params, oper);
        JaxbProcessInstanceListResponse response = this.getProcessInstanceListResponse(varLogList, pageInfo);
        return RuntimeResource.createCorrectVariant(response, this.headers);
    }

    @GET
    @Path(value="/history/variable/{varId: [a-zA-Z0-9-:\\.]+}/value/{value: [a-zA-Z0-9-:\\.]+}/instances")
    public Response history_variable_varId_value_valueVal_instances(@PathParam(value="procId") String variableId, @PathParam(value="value") String value) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String oper = this.getRelativePath(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params, oper);
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, value, params, oper);
        JaxbProcessInstanceListResponse response = this.getProcessInstanceListResponse(varLogList, pageInfo);
        return RuntimeResource.createCorrectVariant(response, this.headers);
    }

    @POST
    @Path(value="/withvars/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public Response withvars_process_processDefId_start(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> requestParams = RuntimeResource.getRequestParams(this.request);
        String oper = this.getRelativePath(this.request);
        Map<String, Object> params = RuntimeResource.extractMapFromParams(requestParams, oper);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new StartProcessCommand(processId, params), this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, requestParams, oper, true), "Unable to get process instance logs for process '" + processId + "'");
        ProcessInstance procInst = (ProcessInstance)result;
        Map<String, String> vars = this.getVariables(procInst.getId());
        JaxbProcessInstanceWithVariablesResponse resp = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.request);
        return RuntimeResource.createCorrectVariant(resp, this.headers);
    }

    @GET
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}")
    public Response withvars_process_instance_procInstId(@PathParam(value="procInstId") Long procInstId) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(procInstId);
        cmd.setReadOnly(true);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, "Unable to get process instance " + procInstId);
        JaxbProcessInstanceWithVariablesResponse responseObj = null;
        if (result == null) {
            throw new BadRequestException("Unable to retrieve process instance " + procInstId + " since it has been completed. Please see the history operations.");
        }
        ProcessInstance procInst = (ProcessInstance)result;
        Map<String, String> vars = this.getVariables(procInstId);
        responseObj = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.request);
        return RuntimeResource.createCorrectVariant(responseObj, this.headers);
    }

    @POST
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}/signal")
    public Response withvars_process_instance_procInstid_signal(@PathParam(value="procInstId") Long procInstId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String eventType = RuntimeResource.getStringParam("eventType", true, params, "signal");
        Object event = RuntimeResource.getObjectParam("event", false, params, "signal");
        String errorMsg = "Unable to signal process instance " + procInstId;
        errorMsg = eventType == null ? errorMsg + " with empty signal" : errorMsg + " with signal type '" + eventType + "'";
        if (event != null) {
            errorMsg = errorMsg + " and event '" + event + "'";
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)new SignalEventCommand(procInstId.longValue(), eventType, event), this.deploymentId, procInstId, errorMsg);
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(procInstId);
        cmd.setReadOnly(true);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, "Unable to get process instance " + procInstId);
        ProcessInstance processInstance = (ProcessInstance)result;
        if (processInstance == null) {
            throw new KieRemoteServicesPreConditionException("This method can only be used on processes that will not complete after a signal.");
        }
        Map<String, String> vars = this.getVariables(processInstance.getId());
        return RuntimeResource.createCorrectVariant(new JaxbProcessInstanceWithVariablesResponse(processInstance, vars), this.headers);
    }

    private List<VariableInstanceLog> internalGetVariableInstancesByVarAndValue(String varId, String value, Map<String, List<String>> params, String oper) {
        String errMsg;
        FindVariableInstancesByNameCommand findVarCmd;
        String activeProcsParam = RuntimeResource.getStringParam("activeProcesses", false, params, oper);
        boolean activeProcesses = true;
        if (activeProcsParam != null) {
            activeProcesses = Boolean.parseBoolean(activeProcsParam);
        }
        if (value == null) {
            findVarCmd = new FindVariableInstancesByNameCommand(varId, activeProcesses);
            errMsg = "Unable to get variable instance logs for variable id '" + varId + "'";
        } else {
            findVarCmd = new FindVariableInstancesByNameCommand(varId, value, activeProcesses);
            errMsg = "Unable to get variable instance logs for variable id '" + varId + "' and value '" + value + "'";
        }
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)findVarCmd, this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, params, oper, true), errMsg);
        return (List)result;
    }

    private JaxbProcessInstanceListResponse getProcessInstanceListResponse(List<VariableInstanceLog> varLogList, int[] pageInfo) {
        JaxbProcessInstanceListResponse response = new JaxbProcessInstanceListResponse();
        response.setCommandName(FindProcessInstanceCommand.class.getSimpleName());
        int numVarLogs = varLogList.size();
        int numResults = pageInfo[PAGE_NUM] * pageInfo[PAGE_SIZE];
        int numProcInsts = 0;
        for (int i = 0; i < numVarLogs && numProcInsts < numResults; ++i) {
            long procInstId = varLogList.get(i).getProcessInstanceId();
            GetProcessInstanceCommand findProcInstCmd = new GetProcessInstanceCommand(Long.valueOf(procInstId));
            Object procInstResult = this.processRequestBean.doKieSessionOperation((Command<?>)findProcInstCmd, this.deploymentId, procInstId, "Unable to get process instance with id id '" + procInstId + "'");
            if (procInstResult == null) continue;
            response.getResult().add(new JaxbProcessInstanceResponse((ProcessInstance)procInstResult));
            ++numProcInsts;
        }
        return response;
    }

    private Map<String, String> getVariables(long processInstanceId) {
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new FindVariableInstancesCommand(processInstanceId), this.deploymentId, processInstanceId, "Unable to retrieve process variables from process instance " + processInstanceId);
        List varInstLogList = (List)result;
        HashMap<String, String> vars = new HashMap<String, String>();
        if (varInstLogList.isEmpty()) {
            return vars;
        }
        HashMap<String, VariableInstanceLog> varLogMap = new HashMap<String, VariableInstanceLog>();
        for (VariableInstanceLog variableInstanceLog : varInstLogList) {
            String varId = variableInstanceLog.getVariableId();
            VariableInstanceLog prevVarLog = varLogMap.put(varId, variableInstanceLog);
            if (prevVarLog == null || !prevVarLog.getDate().after(variableInstanceLog.getDate())) continue;
            varLogMap.put(varId, prevVarLog);
        }
        for (Map.Entry entry : varLogMap.entrySet()) {
            vars.put((String)entry.getKey(), ((VariableInstanceLog)entry.getValue()).getValue());
        }
        return vars;
    }
}

