/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.persistence.SingleSessionCommandService;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.task.TaskService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.services.remote.cdi.RuntimeManagerManager;
import org.kie.services.remote.cdi.TransactionalExecutor;

@RequestScoped
public class RestProcessRequestBean {
    @Inject
    private RuntimeManagerManager runtimeMgrMgr;
    @Inject
    private TaskService taskService;
    @Inject
    private TransactionalExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doKieSessionOperation(Command<?> cmd, String deploymentId, Long processInstanceId, String errorMsg) {
        Object result = null;
        try {
            SingleSessionCommandService sscs;
            RuntimeEngine runtimeEngine = this.runtimeMgrMgr.getRuntimeEngine(deploymentId, processInstanceId);
            KieSession kieSession = runtimeEngine.getKieSession();
            SingleSessionCommandService singleSessionCommandService = sscs = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)kieSession).getCommandService();
            synchronized (singleSessionCommandService) {
                result = this.executor.execute(kieSession, cmd);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new InternalServerErrorException(errorMsg, (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTaskOperationOnDeployment(TaskCommand<?> cmd, String deploymentId, Long processInstanceId, String errorMsg) {
        Object result;
        block8: {
            result = null;
            try {
                if (deploymentId != null) {
                    SingleSessionCommandService sscs;
                    RuntimeEngine runtimeEngine = this.runtimeMgrMgr.getRuntimeEngine(deploymentId, processInstanceId);
                    KieSession kieSession = runtimeEngine.getKieSession();
                    SingleSessionCommandService singleSessionCommandService = sscs = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)kieSession).getCommandService();
                    synchronized (singleSessionCommandService) {
                        result = this.executor.execute((InternalTaskService)this.taskService, cmd);
                        break block8;
                    }
                }
                result = this.executor.execute((InternalTaskService)this.taskService, cmd);
            }
            catch (PermissionDeniedException pde) {
                throw new UnauthorizedException(pde.getMessage(), (Throwable)pde);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new InternalServerErrorException(errorMsg, (Throwable)e);
            }
        }
        return result;
    }

    public Object doTaskOperation(TaskCommand<?> cmd, String errorMsg) {
        return this.doTaskOperationOnDeployment(cmd, null, null, errorMsg);
    }

    public Object doTaskOperationAndSerializeResult(TaskCommand<?> cmd, String errorMsg) {
        Object result = null;
        try {
            result = this.executor.executeAndSerialize((InternalTaskService)this.taskService, cmd);
        }
        catch (PermissionDeniedException pde) {
            throw new UnauthorizedException(pde.getMessage(), (Throwable)pde);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new InternalServerErrorException(errorMsg, (Throwable)e);
        }
        return result;
    }
}

