/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.core.request.ServerDrivenNegotiation;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotAcceptableException;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.query.TaskSummaryImpl;
import org.kie.api.command.Command;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.services.client.api.command.AcceptedCommands;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.remote.rest.RestProcessRequestBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(ResourceBase.class);
    protected static final String PROC_INST_ID_PARAM_NAME = "runtimeProcInstId";
    private static List<Variant> variants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build();
    private static Variant defaultVariant = (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_XML_TYPE}).build().get(0);
    static int PAGE_NUM = 0;
    static int PAGE_SIZE = 1;

    public static JaxbCommandsResponse restProcessJaxbCommandsRequest(JaxbCommandsRequest request, RestProcessRequestBean requestBean) {
        JaxbCommandsResponse jaxbResponse = new JaxbCommandsResponse(request);
        List commands = request.getCommands();
        if (commands != null) {
            int cmdListSize = commands.size();
            for (int i = 0; i < cmdListSize; ++i) {
                Command cmd = (Command)commands.get(i);
                if (!AcceptedCommands.getSet().contains(cmd.getClass())) {
                    throw new NotAcceptableException("The execute REST operation does not accept " + cmd.getClass().getName() + " instances.");
                }
                logger.debug("Processing command " + cmd.getClass().getSimpleName());
                Object cmdResult = null;
                try {
                    String errorMsg = "Unable to execute " + cmd.getClass().getSimpleName() + "/" + i;
                    if (cmd instanceof TaskCommand) {
                        TaskCommand taskCmd = (TaskCommand)cmd;
                        cmdResult = AcceptedCommands.TASK_COMMANDS_THAT_INFLUENCE_KIESESSION.contains(cmd.getClass()) ? requestBean.doTaskOperationOnDeployment(taskCmd, request.getDeploymentId(), request.getProcessInstanceId(), errorMsg) : requestBean.doTaskOperationAndSerializeResult(taskCmd, errorMsg);
                    } else {
                        cmdResult = requestBean.doKieSessionOperation(cmd, request.getDeploymentId(), request.getProcessInstanceId(), errorMsg);
                    }
                }
                catch (Exception e) {
                    jaxbResponse.addException(e, i, cmd);
                    logger.warn("Unable to execute " + cmd.getClass().getSimpleName() + "/" + i + " because of " + e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
                }
                if (cmdResult == null) continue;
                try {
                    jaxbResponse.addResult(cmdResult, i, cmd);
                    continue;
                }
                catch (Exception e) {
                    logger.error("Unable to add result from " + cmd.getClass().getSimpleName() + "/" + i + " because of " + e.getClass().getSimpleName(), (Throwable)e);
                    jaxbResponse.addException(e, i, cmd);
                }
            }
        }
        if (commands == null || commands.isEmpty()) {
            logger.info("Commands request object with no commands sent!");
        }
        return jaxbResponse;
    }

    public static Variant getVariant(HttpHeaders headers) {
        ServerDrivenNegotiation negotiation = new ServerDrivenNegotiation();
        MultivaluedMap requestHeaders = headers.getRequestHeaders();
        ArrayList<String> acceptHeaders = (ArrayList<String>)requestHeaders.get((Object)"Accept");
        if (acceptHeaders != null && !acceptHeaders.isEmpty()) {
            ArrayList<String> fixedAcceptHeaders = new ArrayList<String>();
            for (String header : acceptHeaders) {
                fixedAcceptHeaders.add(header.replaceAll("q=\\.", "q=0."));
            }
            acceptHeaders = fixedAcceptHeaders;
        }
        negotiation.setAcceptHeaders((List)acceptHeaders);
        negotiation.setAcceptCharsetHeaders((List)requestHeaders.get((Object)"Accept-Charset"));
        negotiation.setAcceptEncodingHeaders((List)requestHeaders.get((Object)"Accept-Encoding"));
        negotiation.setAcceptLanguageHeaders((List)requestHeaders.get((Object)"Accept-Language"));
        return negotiation.getBestMatch(variants);
    }

    protected static Response createCorrectVariant(Object responseObj, HttpHeaders headers) {
        return ResourceBase.createCorrectVariant(responseObj, headers, true);
    }

    protected static Response createCorrectVariant(Object responseObj, HttpHeaders headers, boolean useDefault) {
        Variant v = ResourceBase.getVariant(headers);
        if (v != null) {
            return Response.ok((Object)responseObj, (Variant)v).build();
        }
        if (useDefault) {
            return Response.ok((Object)responseObj, (Variant)defaultVariant).build();
        }
        return Response.notAcceptable(variants).build();
    }

    protected static Map<String, List<String>> getRequestParams(HttpServletRequest request) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            parameters.put(name, Arrays.asList(request.getParameterValues(name)));
        }
        return parameters;
    }

    protected static String getStringParam(String paramName, boolean required, Map<String, List<String>> params, String operation) {
        List<String> paramValues = ResourceBase.getStringListParam(paramName, required, params, operation);
        if (!required && paramValues.isEmpty()) {
            return null;
        }
        if (paramValues.size() != 1) {
            throw new BadRequestException("One and only one '" + paramName + "' query parameter required for '" + operation + "' operation (" + paramValues.size() + " passed).");
        }
        return paramValues.get(0);
    }

    protected static List<String> getStringListParam(String paramName, boolean required, Map<String, List<String>> params, String operation) {
        List<String> paramValues = null;
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(paramName)) continue;
            paramValues = entry.getValue();
            break;
        }
        if (paramValues == null) {
            if (required) {
                throw new BadRequestException("Query parameter '" + paramName + "' required for '" + operation + "' operation.");
            }
            return new ArrayList<String>();
        }
        return paramValues;
    }

    protected static Object getObjectParam(String paramName, boolean required, Map<String, List<String>> params, String operation) {
        String paramVal = ResourceBase.getStringParam(paramName, required, params, operation);
        if (!required && paramVal == null) {
            return null;
        }
        return ResourceBase.getObjectFromString(paramName, paramVal);
    }

    protected static List<Long> getLongListParam(String paramName, boolean required, Map<String, List<String>> params, String operation, boolean mustBeLong) {
        List<String> paramValues = ResourceBase.getStringListParam(paramName, required, params, operation);
        ArrayList<Long> longValues = new ArrayList<Long>();
        for (String strVal : paramValues) {
            longValues.add((Long)ResourceBase.getNumberFromString(paramName, strVal, mustBeLong));
        }
        return longValues;
    }

    protected static Number getNumberParam(String paramName, boolean required, Map<String, List<String>> params, String operation, boolean mustBeLong) {
        String paramVal = ResourceBase.getStringParam(paramName, required, params, operation);
        if (!required && paramVal == null) {
            return null;
        }
        return ResourceBase.getNumberFromString(paramName, paramVal, mustBeLong);
    }

    private static Object getObjectFromString(String key, String mapVal) {
        if (!mapVal.matches("^\\d+[li]?$")) {
            return mapVal;
        }
        return ResourceBase.getNumberFromString(key, mapVal, false);
    }

    private static Number getNumberFromString(String paramName, String paramVal, boolean mustBeLong) {
        if (paramVal.matches("^\\d+[li]?$")) {
            if (paramVal.matches(".*i$")) {
                if (mustBeLong) {
                    throw new BadRequestException(paramName + " parameter is numerical but contains the \"Integer\" suffix 'i' and must have no suffix or \"Long\" suffix 'l' (" + paramVal + ")");
                }
                if ((paramVal = paramVal.substring(0, paramVal.length() - 1)).length() > 9) {
                    throw new BadRequestException(paramName + " parameter is numerical but too large to be an integer (" + paramVal + "i)");
                }
                return Integer.parseInt(paramVal);
            }
            if (paramVal.length() > 18) {
                throw new BadRequestException(paramName + " parameter is numerical but too large to be a long (" + paramVal + ")");
            }
            if (paramVal.matches(".*l$")) {
                paramVal = paramVal.substring(0, paramVal.length() - 1);
            }
            return Long.parseLong(paramVal);
        }
        throw new BadRequestException(paramName + " parameter does not have a numerical format (" + paramVal + ")");
    }

    protected static Map<String, Object> extractMapFromParams(Map<String, List<String>> params, String operation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            if (!entry.getKey().startsWith("map_")) continue;
            String key = entry.getKey();
            List<String> paramValues = entry.getValue();
            if (paramValues.size() != 1) {
                throw new BadRequestException("Only one map_* (" + key + ") query parameter allowed for '" + operation + "' operation (" + paramValues.size() + " passed).");
            }
            String mapKey = key.substring("map_".length());
            String mapVal = paramValues.get(0).trim();
            map.put(mapKey, ResourceBase.getObjectFromString(key, mapVal));
        }
        return map;
    }

    protected static List<OrganizationalEntity> getOrganizationalEntityListFromParams(Map<String, List<String>> params, boolean required, String operation) {
        ArrayList<OrganizationalEntity> orgEntList = new ArrayList<OrganizationalEntity>();
        List<String> users = ResourceBase.getStringListParam("user", false, params, "nominate");
        List<String> groups = ResourceBase.getStringListParam("group", false, params, "nominate");
        if (required && users.isEmpty() && groups.isEmpty()) {
            throw new BadRequestException("At least 1 query parameter (either 'user' or 'group') is required for the '" + operation + "' operation.");
        }
        for (String user : users) {
            orgEntList.add((OrganizationalEntity)new UserImpl(user));
        }
        for (String group : groups) {
            orgEntList.add((OrganizationalEntity)new GroupImpl(group));
        }
        return orgEntList;
    }

    protected static TaskSummaryImpl convertTaskToTaskSummary(TaskImpl task) {
        TaskSummaryImpl taskSummary = new TaskSummaryImpl(task.getId().longValue(), task.getTaskData().getProcessInstanceId(), ((I18NText)task.getNames().get(0)).getText(), ((I18NText)task.getSubjects().get(0)).getText(), ((I18NText)task.getDescriptions().get(0)).getText(), task.getTaskData().getStatus(), task.getPriority(), task.getTaskData().isSkipable(), task.getTaskData().getActualOwner(), task.getTaskData().getCreatedBy(), task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), task.getSubTaskStrategy(), task.getTaskData().getParentId());
        return taskSummary;
    }

    protected static List<Status> convertStringListToStatusList(List<String> statusStrList) {
        ArrayList<Status> statuses = null;
        if (statusStrList != null && !statusStrList.isEmpty()) {
            statuses = new ArrayList<Status>();
            for (String statusStr : statusStrList) {
                String goodStatusStr = statusStr.substring(0, 1).toUpperCase() + statusStr.substring(1).toLowerCase();
                try {
                    statuses.add(Status.valueOf((String)goodStatusStr));
                }
                catch (IllegalArgumentException iae) {
                    throw new BadRequestException(goodStatusStr + " is not a valid status type for a task.");
                }
            }
        }
        return statuses;
    }

    protected static int[] getPageNumAndPageSize(Map<String, List<String>> params, String oper) {
        int[] pageInfo = new int[2];
        Number page = ResourceBase.getNumberParam("page", false, params, oper, false);
        Number pageShort = ResourceBase.getNumberParam("p", false, params, oper, false);
        Number pageSize = ResourceBase.getNumberParam("pageSize", false, params, oper, false);
        Number pageSizeShort = ResourceBase.getNumberParam("s", false, params, oper, false);
        int p = 0;
        int s = 10;
        if (page != null) {
            p = page.intValue();
        } else if (pageShort != null) {
            p = pageShort.intValue();
        }
        if (p < 0) {
            p = 0;
        }
        if (pageSize != null) {
            s = pageSize.intValue();
        } else if (pageSizeShort != null) {
            s = pageSizeShort.intValue();
        }
        if (s < 0) {
            s = 0;
        }
        pageInfo[ResourceBase.PAGE_NUM] = p;
        pageInfo[ResourceBase.PAGE_SIZE] = s;
        return pageInfo;
    }

    protected String getRelativePath(HttpServletRequest request) {
        String path = request.getRequestURL().toString();
        path = path.replaceAll(".*" + request.getServletContext().getContextPath(), "");
        return path;
    }
}

