/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.jms;

import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.jbpm.services.task.commands.TaskCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.task.TaskService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.services.client.api.command.AcceptedCommands;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.SerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.remote.cdi.RuntimeManagerManager;
import org.kie.services.remote.cdi.TransactionalExecutor;
import org.kie.services.remote.exception.KieRemoteServicesInternalError;
import org.kie.services.remote.exception.KieRemoteServicesRuntimeException;
import org.kie.services.remote.jms.RetryTrackerSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMessageBean
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(RequestMessageBean.class);
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory connectionFactory;
    @Resource
    private MessageDrivenContext context;
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory factory;
    private Session session;
    private Connection connection;
    @Inject
    private RetryTrackerSingleton retryTracker;
    @Inject
    private RuntimeManagerManager runtimeMgrMgr;
    @Inject
    private TaskService taskService;
    @Inject
    private TransactionalExecutor executor;
    private String RESPONSE_QUEUE_NAME = null;
    private static String RESPONSE_QUEUE_NAME_PROPERTY = "kie.services.jms.queues.response";
    private static final String ID_NECESSARY = "This id is needed to be able to match a request to a response message.";

    @PostConstruct
    public void init() {
        this.RESPONSE_QUEUE_NAME = System.getProperty(RESPONSE_QUEUE_NAME_PROPERTY, "queue/KIE.RESPONSE.ALL");
        try {
            this.connection = this.factory.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.connection.start();
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to open new session to send response messages";
            logger.error(errMsg, (Throwable)jmse);
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
    }

    @PreDestroy
    public void cleanup() {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to close " + (this.connection == null ? "session" : "connection");
            logger.error(errMsg, (Throwable)jmse);
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void onMessage(Message message) {
        SerializationProvider serializationProvider;
        String msgId = null;
        Boolean redelivered = null;
        try {
            msgId = message.getJMSMessageID();
            redelivered = message.getJMSRedelivered();
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to retrieve JMS " + (msgId == null ? "redelivered flag" : "message id") + " from JMS message. Failing and NOT returning message to queue.";
            logger.warn(errMsg, (Throwable)jmse);
        }
        if (redelivered.booleanValue()) {
            if (this.retryTracker.maxRetriesReached(msgId)) {
                logger.warn("Maximum number of retries (" + this.retryTracker.getMaximumLimitRetries() + ") reached for message " + msgId);
                logger.warn("Acknowledging message but NOT processing it.");
                return;
            }
            logger.warn("Retry number " + this.retryTracker.incrementRetries(msgId) + " of message " + msgId);
        }
        String msgCorrId = null;
        JaxbCommandsResponse jaxbResponse = null;
        try {
            msgCorrId = message.getJMSCorrelationID();
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to retrieve JMS correlation id from message! This id is needed to be able to match a request to a response message.";
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
        int serializationType = -1;
        try {
            serializationType = !message.propertyExists("serialization") ? 0 : message.getIntProperty("serialization");
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to get properties from message " + msgCorrId + ".";
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
        switch (serializationType) {
            case 0: {
                serializationProvider = RequestMessageBean.getJaxbSerializationProvider(message);
                break;
            }
            default: {
                throw new KieRemoteServicesInternalError("Unknown serialization type: " + serializationType);
            }
        }
        JaxbCommandsRequest cmdsRequest = RequestMessageBean.deserializeRequest(message, msgCorrId, serializationProvider, serializationType);
        jaxbResponse = this.processJaxbCommandsRequest(cmdsRequest);
        Message msg = RequestMessageBean.serializeResponse(this.session, msgCorrId, serializationType, serializationProvider, jaxbResponse);
        this.sendResponse(msgCorrId, serializationType, msg);
        if (redelivered.booleanValue()) {
            this.retryTracker.clearRetries(msgId);
        }
    }

    private void sendResponse(String msgCorrId, int serializationType, Message msg) {
        try {
            msg.setJMSCorrelationID(msgCorrId);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to set correlation id of response to msg id " + msgCorrId;
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
        try {
            Queue responseQueue = (Queue)new InitialContext().lookup(this.RESPONSE_QUEUE_NAME);
            MessageProducer producer = this.session.createProducer((Destination)responseQueue);
            producer.send(msg);
        }
        catch (NamingException ne) {
            String errMsg = "Unable to lookup response queue " + this.RESPONSE_QUEUE_NAME + " to send msg " + msgCorrId + " (Is " + RESPONSE_QUEUE_NAME_PROPERTY + " incorrect?).";
            throw new KieRemoteServicesRuntimeException(errMsg, ne);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to send msg " + msgCorrId + " to " + this.RESPONSE_QUEUE_NAME;
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
    }

    private static JaxbCommandsRequest deserializeRequest(Message message, String msgId, SerializationProvider serializationProvider, int serializationType) {
        JaxbCommandsRequest cmdMsg = null;
        try {
            String msgStrContent = null;
            switch (serializationType) {
                case 0: {
                    msgStrContent = ((BytesMessage)message).readUTF();
                    cmdMsg = (JaxbCommandsRequest)serializationProvider.deserialize((Object)msgStrContent);
                    break;
                }
                default: {
                    throw new KieRemoteServicesRuntimeException("Unknown serialization type when deserializing message " + msgId + ":" + serializationType);
                }
            }
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to read information from message " + msgId + ".";
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
        catch (Exception e) {
            String errMsg = "Unable to serialize String to " + JaxbCommandsRequest.class.getSimpleName() + " [msg id: " + msgId + "].";
            throw new KieRemoteServicesInternalError(errMsg, e);
        }
        return cmdMsg;
    }

    private static SerializationProvider getJaxbSerializationProvider(Message message) {
        JaxbSerializationProvider serializationProvider;
        try {
            if (message.propertyExists("extraJaxbClasses")) {
                String extraClassesString = message.getStringProperty("extraJaxbClasses");
                Set extraClassesList = JaxbSerializationProvider.commaSeperatedStringToClassSet((String)extraClassesString);
                serializationProvider = new JaxbSerializationProvider(extraClassesList);
            } else {
                serializationProvider = new JaxbSerializationProvider();
            }
        }
        catch (JMSException jmse) {
            throw new KieRemoteServicesInternalError("Unable to check or read JMS message for property.", jmse);
        }
        catch (SerializationException se) {
            throw new KieRemoteServicesRuntimeException("Unable to load classes needed for JAXB deserialization.", se);
        }
        return serializationProvider;
    }

    private static Message serializeResponse(Session session, String msgId, int serializationType, SerializationProvider serializationProvider, JaxbCommandsResponse jaxbResponse) {
        BytesMessage byteMsg = null;
        try {
            String msgStr;
            byteMsg = session.createBytesMessage();
            byteMsg.setIntProperty("serialization", serializationType);
            switch (serializationType) {
                case 0: {
                    String propValue;
                    msgStr = (String)serializationProvider.serialize((Object)jaxbResponse);
                    Set extraJaxbClasses = ((JaxbSerializationProvider)serializationProvider).getExtraJaxbClasses();
                    if (extraJaxbClasses.isEmpty()) break;
                    try {
                        propValue = JaxbSerializationProvider.classSetToCommaSeperatedString((Set)extraJaxbClasses);
                    }
                    catch (SerializationException se) {
                        throw new KieRemoteServicesRuntimeException("Unable to get class names for extra JAXB classes.", se);
                    }
                    byteMsg.setStringProperty("extraJaxbClasses", propValue);
                    break;
                }
                default: {
                    throw new KieRemoteServicesRuntimeException("Unknown serialization type when deserializing message " + msgId + ":" + serializationType);
                }
            }
            byteMsg.writeUTF(msgStr);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to create response message or write to it [msg id: " + msgId + "].";
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
        catch (Exception e) {
            String errMsg = "Unable to serialize " + jaxbResponse.getClass().getSimpleName() + " to a String.";
            throw new KieRemoteServicesInternalError(errMsg, e);
        }
        return byteMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaxbCommandsResponse processJaxbCommandsRequest(JaxbCommandsRequest request) {
        JaxbCommandsResponse jaxbResponse = new JaxbCommandsResponse(request);
        List commands = request.getCommands();
        if (commands != null) {
            for (int i = 0; i < commands.size(); ++i) {
                String errMsg;
                Object cmdResult;
                Command cmd;
                block12: {
                    cmd = (Command)commands.get(i);
                    if (!AcceptedCommands.getSet().contains(cmd.getClass())) {
                        UnsupportedOperationException uoe = new UnsupportedOperationException(cmd.getClass().getName() + " is not a supported command.");
                        jaxbResponse.addException((Exception)uoe, i, cmd);
                        continue;
                    }
                    cmdResult = null;
                    try {
                        SingleSessionCommandService sscs;
                        if (cmd instanceof TaskCommand && !AcceptedCommands.TASK_COMMANDS_THAT_INFLUENCE_KIESESSION.contains(cmd.getClass())) {
                            cmdResult = this.executor.executeAndSerialize((InternalTaskService)this.taskService, (TaskCommand)cmd);
                            break block12;
                        }
                        KieSession kieSession = this.runtimeMgrMgr.getRuntimeEngine(request.getDeploymentId(), request.getProcessInstanceId()).getKieSession();
                        SingleSessionCommandService singleSessionCommandService = sscs = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)kieSession).getCommandService();
                        synchronized (singleSessionCommandService) {
                            cmdResult = cmd instanceof TaskCommand ? this.executor.execute((InternalTaskService)this.taskService, (TaskCommand)cmd) : this.executor.execute(kieSession, cmd);
                        }
                    }
                    catch (Exception e) {
                        errMsg = "Unable to execute " + cmd.getClass().getSimpleName() + " because of " + e.getClass().getSimpleName() + ": " + e.getMessage();
                        logger.warn(errMsg, (Throwable)e);
                        jaxbResponse.addException((Exception)new KieRemoteServicesRuntimeException(errMsg, e), i, cmd);
                    }
                }
                if (cmdResult == null) continue;
                try {
                    jaxbResponse.addResult(cmdResult, i, cmd);
                    continue;
                }
                catch (Exception e) {
                    errMsg = "Unable to add result from " + cmd.getClass().getSimpleName() + "/" + i + " because of " + e.getClass().getSimpleName();
                    logger.error(errMsg, (Throwable)e);
                    jaxbResponse.addException((Exception)new KieRemoteServicesRuntimeException(errMsg, e), i, cmd);
                }
            }
        }
        if (commands == null || commands.isEmpty()) {
            logger.info("Commands request object with no commands sent!");
        }
        return jaxbResponse;
    }
}

