/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.cdi;

import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import org.jboss.seam.transaction.TransactionInterceptor;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.impl.model.xml.JaxbContent;
import org.jbpm.services.task.impl.model.xml.JaxbTask;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.InternalTaskService;

@Transactional
@Interceptors(value={TransactionInterceptor.class})
public class TransactionalExecutor {
    @Inject
    private EntityManager em;

    public Object execute(KieSession kieSession, Command<?> cmd) {
        return kieSession.execute(cmd);
    }

    public Object execute(InternalTaskService taskService, TaskCommand<?> cmd) {
        this.em.joinTransaction();
        return taskService.execute(cmd);
    }

    public Object executeAndSerialize(InternalTaskService taskService, TaskCommand<?> cmd) {
        this.em.joinTransaction();
        Object cmdResult = taskService.execute(cmd);
        if (cmdResult == null) {
            return null;
        }
        if (cmdResult instanceof Task) {
            cmdResult = new JaxbTask((Task)cmdResult);
        } else if (cmdResult instanceof Content) {
            cmdResult = new JaxbContent((Content)cmdResult);
        }
        return cmdResult;
    }
}

