/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.postgresql;

import io.quarkus.arc.AlternativePriority;
import io.quarkus.arc.properties.IfBuildProperty;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequest;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityResult;
import org.kie.kogito.explainability.api.LIMEExplainabilityResult;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.trusty.storage.api.model.decision.DMNModelWithMetadata;
import org.kie.kogito.trusty.storage.api.model.decision.Decision;
import org.kie.kogito.trusty.storage.postgresql.CounterfactualRequestsStorage;
import org.kie.kogito.trusty.storage.postgresql.CounterfactualResultsStorage;
import org.kie.kogito.trusty.storage.postgresql.DMNModelWithMetadataStorage;
import org.kie.kogito.trusty.storage.postgresql.DecisionsStorage;
import org.kie.kogito.trusty.storage.postgresql.LIMEResultsStorage;

@ApplicationScoped
@AlternativePriority(value=1)
@IfBuildProperty(name="kogito.persistence.type", stringValue="postgresql")
public class PostgresStorageService
implements StorageService {
    private DecisionsStorage decisionsStorage;
    private LIMEResultsStorage limeResultsStorage;
    private DMNModelWithMetadataStorage dmnModelWithMetadataStorage;
    private CounterfactualRequestsStorage counterfactualRequestsStorage;
    private CounterfactualResultsStorage counterfactualResultsStorage;

    PostgresStorageService() {
    }

    @Inject
    public PostgresStorageService(DecisionsStorage decisionsStorage, LIMEResultsStorage limeResultsStorage, DMNModelWithMetadataStorage dmnModelWithMetadataStorage, CounterfactualRequestsStorage counterfactualRequestsStorage, CounterfactualResultsStorage counterfactualResultsStorage) {
        this.decisionsStorage = decisionsStorage;
        this.limeResultsStorage = limeResultsStorage;
        this.dmnModelWithMetadataStorage = dmnModelWithMetadataStorage;
        this.counterfactualRequestsStorage = counterfactualRequestsStorage;
        this.counterfactualResultsStorage = counterfactualResultsStorage;
    }

    public Storage<String, String> getCache(String name) {
        throw new UnsupportedOperationException("Generic String cache not available in PostgresSQL");
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type) {
        if (type == Decision.class) {
            return this.decisionsStorage;
        }
        if (type == LIMEExplainabilityResult.class) {
            return this.limeResultsStorage;
        }
        if (type == DMNModelWithMetadata.class) {
            return this.dmnModelWithMetadataStorage;
        }
        if (type == CounterfactualExplainabilityRequest.class) {
            return this.counterfactualRequestsStorage;
        }
        if (type == CounterfactualExplainabilityResult.class) {
            return this.counterfactualResultsStorage;
        }
        throw new UnsupportedOperationException(String.format("Unknown class type: %s, cache not available", type.getCanonicalName()));
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type, String rootType) {
        throw new UnsupportedOperationException("Generic String cache not available in PostgresSQL");
    }
}

