/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.postgresql;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.smallrye.mutiny.Multi;
import java.util.Map;
import javax.transaction.Transactional;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.postgresql.PostgresStorage;
import org.kie.kogito.persistence.postgresql.model.CacheEntityRepository;

public abstract class BaseTransactionalStorage<T>
implements Storage<String, T> {
    private PostgresStorage<T> delegate;

    BaseTransactionalStorage() {
    }

    public BaseTransactionalStorage(String name, CacheEntityRepository repository, ObjectMapper mapper, Class<T> type) {
        this(new PostgresStorage(name, repository, mapper, type));
    }

    BaseTransactionalStorage(PostgresStorage<T> delegate) {
        this.delegate = delegate;
    }

    public Multi<T> objectCreatedListener() {
        return this.delegate.objectCreatedListener();
    }

    public Multi<T> objectUpdatedListener() {
        return this.delegate.objectUpdatedListener();
    }

    public Multi<String> objectRemovedListener() {
        return this.delegate.objectRemovedListener();
    }

    @Transactional
    public Query<T> query() {
        return this.delegate.query();
    }

    @Transactional
    public T get(String key) {
        return (T)this.delegate.get(key);
    }

    @Transactional
    public T put(String key, T value) {
        return (T)this.delegate.put(key, value);
    }

    @Transactional
    public T remove(String key) {
        return (T)this.delegate.remove(key);
    }

    @Transactional
    public boolean containsKey(String key) {
        return this.delegate.containsKey(key);
    }

    @Transactional
    public Map<String, T> entries() {
        return this.delegate.entries();
    }

    @Transactional
    public void clear() {
        this.delegate.clear();
    }

    public String getRootType() {
        return this.delegate.getRootType();
    }
}

