/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.postgresql;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequest;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityResult;
import org.kie.kogito.explainability.api.LIMEExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.decision.DMNModelWithMetadata;
import org.kie.kogito.trusty.storage.api.model.decision.Decision;
import org.kie.kogito.trusty.storage.postgresql.CounterfactualRequestsStorage;
import org.kie.kogito.trusty.storage.postgresql.CounterfactualResultsStorage;
import org.kie.kogito.trusty.storage.postgresql.DMNModelWithMetadataStorage;
import org.kie.kogito.trusty.storage.postgresql.DecisionsStorage;
import org.kie.kogito.trusty.storage.postgresql.LIMEResultsStorage;
import org.kie.kogito.trusty.storage.postgresql.PostgresStorageService;
import org.mockito.Mockito;

public class PostgresStorageServiceTest {
    private DecisionsStorage decisionsStorage;
    private LIMEResultsStorage limeResultsStorage;
    private DMNModelWithMetadataStorage dmnModelWithMetadataStorage;
    private CounterfactualRequestsStorage counterfactualRequestsStorage;
    private CounterfactualResultsStorage counterfactualResultsStorage;
    private PostgresStorageService storageService;

    @BeforeEach
    public void setup() {
        this.decisionsStorage = (DecisionsStorage)Mockito.mock(DecisionsStorage.class);
        this.limeResultsStorage = (LIMEResultsStorage)Mockito.mock(LIMEResultsStorage.class);
        this.dmnModelWithMetadataStorage = (DMNModelWithMetadataStorage)Mockito.mock(DMNModelWithMetadataStorage.class);
        this.counterfactualRequestsStorage = (CounterfactualRequestsStorage)Mockito.mock(CounterfactualRequestsStorage.class);
        this.counterfactualResultsStorage = (CounterfactualResultsStorage)Mockito.mock(CounterfactualResultsStorage.class);
        this.storageService = new PostgresStorageService(this.decisionsStorage, this.limeResultsStorage, this.dmnModelWithMetadataStorage, this.counterfactualRequestsStorage, this.counterfactualResultsStorage);
    }

    @Test
    void testGetCacheWithName() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.storageService.getCache("name"));
    }

    @Test
    void testGetCacheWithNameTypeRoot() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.storageService.getCache("name", String.class, "String"));
    }

    @Test
    void testGetCacheWithNameType_Decisions() {
        Assertions.assertEquals((Object)this.decisionsStorage, (Object)this.storageService.getCache("decisions", Decision.class));
    }

    @Test
    void testGetCacheWithNameType_LIMEResults() {
        Assertions.assertEquals((Object)this.limeResultsStorage, (Object)this.storageService.getCache("limeResults", LIMEExplainabilityResult.class));
    }

    @Test
    void testGetCacheWithNameType_Models() {
        Assertions.assertEquals((Object)this.dmnModelWithMetadataStorage, (Object)this.storageService.getCache("models", DMNModelWithMetadata.class));
    }

    @Test
    void testGetCacheWithNameType_CounterfactualExplainabilityRequests() {
        Assertions.assertEquals((Object)this.counterfactualRequestsStorage, (Object)this.storageService.getCache("counterfactualRequests", CounterfactualExplainabilityRequest.class));
    }

    @Test
    void testGetCacheWithNameType_CounterfactualExplainabilityResults() {
        Assertions.assertEquals((Object)this.counterfactualResultsStorage, (Object)this.storageService.getCache("counterfactualResults", CounterfactualExplainabilityResult.class));
    }

    @Test
    void testGetCacheWithNameType_UnknownType() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.storageService.getCache("name", String.class));
    }
}

