/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.postgresql;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.postgresql.PostgresStorage;
import org.kie.kogito.trusty.storage.postgresql.BaseTransactionalStorage;
import org.mockito.Mockito;

public class BaseTransactionalStorageTest {
    private static final String KEY = "KEY";
    private static final String VALUE = "VALUE";
    private static PostgresStorage<String> delegate;
    private static BaseTransactionalStorage<String> storage;

    @BeforeAll
    public static void setup() {
        delegate = (PostgresStorage)Mockito.mock(PostgresStorage.class);
        storage = new StringStorage(delegate);
    }

    @Test
    public void testObjectCreatedListener() {
        storage.objectCreatedListener();
        ((PostgresStorage)Mockito.verify(delegate)).objectCreatedListener();
    }

    @Test
    public void testObjectUpdatedListener() {
        storage.objectUpdatedListener();
        ((PostgresStorage)Mockito.verify(delegate)).objectUpdatedListener();
    }

    @Test
    public void testObjectRemovedListener() {
        storage.objectRemovedListener();
        ((PostgresStorage)Mockito.verify(delegate)).objectRemovedListener();
    }

    @Test
    public void testQuery() {
        storage.query();
        ((PostgresStorage)Mockito.verify(delegate)).query();
    }

    @Test
    public void testGet() {
        storage.get(KEY);
        ((PostgresStorage)Mockito.verify(delegate)).get(KEY);
    }

    @Test
    public void testPut() {
        storage.put(KEY, (Object)VALUE);
        ((PostgresStorage)Mockito.verify(delegate)).put(KEY, (Object)VALUE);
    }

    @Test
    public void testRemove() {
        storage.remove(KEY);
        ((PostgresStorage)Mockito.verify(delegate)).remove(KEY);
    }

    @Test
    public void testContainsKey() {
        storage.containsKey(KEY);
        ((PostgresStorage)Mockito.verify(delegate)).containsKey(KEY);
    }

    @Test
    public void testEntries() {
        storage.entries();
        ((PostgresStorage)Mockito.verify(delegate)).entries();
    }

    @Test
    public void testClear() {
        storage.clear();
        ((PostgresStorage)Mockito.verify(delegate)).clear();
    }

    @Test
    public void testGetRootType() {
        storage.getRootType();
        ((PostgresStorage)Mockito.verify(delegate)).getRootType();
    }

    private static class StringStorage
    extends BaseTransactionalStorage<String> {
        public StringStorage(PostgresStorage<String> delegate) {
            super(delegate);
        }
    }
}

