/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.api;

import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.jboss.resteasy.annotations.jaxrs.PathParam;
import org.kie.kogito.trusty.service.common.TrustyService;
import org.kie.kogito.trusty.service.common.responses.SalienciesResponse;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;

@Path(value="executions/decisions")
public class ExplainabilityApiV1 {
    @Inject
    TrustyService trustyService;

    @GET
    @Path(value="/{executionId}/explanations/saliencies")
    @APIResponses(value={@APIResponse(description="Gets the local explanation of a decision.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=SalienciesResponse.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Returns the saliencies for a decision.", description="Returns the saliencies for a particular decision calculated using the lime algorithm.")
    @Produces(value={"application/json"})
    public Response getSaliencies(@Parameter(name="executionId", description="The execution ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="executionId") String executionId) {
        return this.retrieveExplainabilityResult(executionId).map(obj -> Response.ok(new SalienciesResponse((ExplainabilityResult)obj)).build()).orElseGet(() -> Response.status(Response.Status.BAD_REQUEST.getStatusCode()).build());
    }

    private Optional<ExplainabilityResult> retrieveExplainabilityResult(String executionId) {
        try {
            return Optional.ofNullable(this.trustyService.getExplainabilityResultById(executionId));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }
}

