/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.paths;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionConstant;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.operation.OperationReader;
import io.smallrye.openapi.runtime.io.parameter.ParameterReader;
import io.smallrye.openapi.runtime.io.server.ServerReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.MethodInfo;

public class PathsReader {
    private PathsReader() {
    }

    public static Paths readPaths(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        PathsImpl paths = new PathsImpl();
        Iterator<String> fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = fieldNames.next();
            if (ExtensionConstant.isExtensionField(fieldName)) continue;
            paths.addPathItem(fieldName, PathsReader.readPathItem(node.get(fieldName)));
        }
        ExtensionReader.readExtensions(node, paths);
        return paths;
    }

    public static PathItem readPathItem(AnnotationScannerContext context, AnnotationValue annotationValue) {
        return PathsReader.readPathItem(context, annotationValue, null);
    }

    public static PathItem readPathItem(AnnotationScannerContext context, AnnotationValue annotationValue, MethodInfo methodInfo) {
        if (annotationValue == null) {
            return null;
        }
        AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
        PathItemImpl pathItem = new PathItemImpl();
        for (AnnotationInstance operationAnno : nestedArray) {
            String method = JandexUtil.stringValue(operationAnno, "method");
            if (method == null) continue;
            Operation operation = OperationReader.readOperation(context, operationAnno, methodInfo);
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(method.toUpperCase(), pathItem.getClass());
                Method mutator = descriptor.getWriteMethod();
                mutator.invoke((Object)pathItem, operation);
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                IoLogging.logger.readingCallbackOperation(e);
            }
        }
        return pathItem;
    }

    public static PathItem readPathItem(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.singleJsonNode("PathItem");
        PathItemImpl pathItem = new PathItemImpl();
        pathItem.setRef(JsonUtil.stringProperty(node, "$ref"));
        pathItem.setSummary(JsonUtil.stringProperty(node, "summary"));
        pathItem.setDescription(JsonUtil.stringProperty(node, "description"));
        pathItem.setGET(OperationReader.readOperation(node.get("get")));
        pathItem.setPUT(OperationReader.readOperation(node.get("put")));
        pathItem.setPOST(OperationReader.readOperation(node.get("post")));
        pathItem.setDELETE(OperationReader.readOperation(node.get("delete")));
        pathItem.setOPTIONS(OperationReader.readOperation(node.get("options")));
        pathItem.setHEAD(OperationReader.readOperation(node.get("head")));
        pathItem.setPATCH(OperationReader.readOperation(node.get("patch")));
        pathItem.setTRACE(OperationReader.readOperation(node.get("trace")));
        pathItem.setParameters(ParameterReader.readParameterList(node.get("parameters")).orElse(null));
        pathItem.setServers(ServerReader.readServers(node.get("servers")).orElse(null));
        ExtensionReader.readExtensions(node, pathItem);
        return pathItem;
    }
}

