/*
 * Decompiled with CFR 0.152.
 */
package io.redisearch.client;

import io.redisearch.Keywords;
import java.util.List;

public class IndexDefinition {
    private Type type = Type.HASH;
    private boolean async = false;
    private String[] prefixes;
    private String filter;
    private String languageField;
    private String language;
    private String scoreFiled;
    private double score = 1.0;
    private String payloadField;

    public Type getType() {
        return this.type;
    }

    public IndexDefinition setType(Type type) {
        this.type = type;
        return this;
    }

    public boolean isAsync() {
        return this.async;
    }

    public IndexDefinition setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public String[] getPrefixes() {
        return this.prefixes;
    }

    public IndexDefinition setPrefixes(String ... prefixes) {
        this.prefixes = prefixes;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public IndexDefinition setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getLanguageField() {
        return this.languageField;
    }

    public IndexDefinition setLanguageField(String languageField) {
        this.languageField = languageField;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public IndexDefinition setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getScoreFiled() {
        return this.scoreFiled;
    }

    public IndexDefinition setScoreFiled(String scoreFiled) {
        this.scoreFiled = scoreFiled;
        return this;
    }

    public double getScore() {
        return this.score;
    }

    public IndexDefinition setScore(double score) {
        this.score = score;
        return this;
    }

    public String getPayloadField() {
        return this.payloadField;
    }

    public IndexDefinition setPayloadField(String payloadField) {
        this.payloadField = payloadField;
        return this;
    }

    public void serializeRedisArgs(List<String> args) {
        if (this.type != null) {
            args.add(Keywords.ON.name());
            args.add(this.type.name());
            if (this.async) {
                args.add(Keywords.ASYNC.name());
            }
            if (this.prefixes != null && this.prefixes.length > 0) {
                args.add(Keywords.PREFIX.name());
                args.add(Integer.toString(this.prefixes.length));
                for (String prefix : this.prefixes) {
                    args.add(prefix);
                }
            }
            if (this.filter != null) {
                args.add(Keywords.FILTER.name());
                args.add(this.filter);
            }
            if (this.languageField != null) {
                args.add(Keywords.LANGUAGE_FIELD.name());
                args.add(this.languageField);
            }
            if (this.language != null) {
                args.add(Keywords.LANGUAGE.name());
                args.add(this.language);
            }
            if (this.scoreFiled != null) {
                args.add(Keywords.SCORE_FIELD.name());
                args.add(this.scoreFiled);
            }
            if (this.score != 1.0) {
                args.add(Keywords.SCORE.name());
                args.add(Double.toString(this.score));
            }
            if (this.payloadField != null) {
                args.add(Keywords.PAYLOAD_FIELD.name());
                args.add(this.payloadField);
            }
        }
    }

    public static enum Type {
        HASH;

    }
}

