/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.swaggerui.runtime;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;

public class SwaggerUiStaticHandler
implements Handler<RoutingContext> {
    private String swaggerUiFinalDestination;
    private String swaggerUiPath;

    public SwaggerUiStaticHandler() {
    }

    public SwaggerUiStaticHandler(String swaggerUiFinalDestination, String swaggerUiPath) {
        this.swaggerUiFinalDestination = swaggerUiFinalDestination;
        this.swaggerUiPath = swaggerUiPath;
    }

    public String getSwaggerUiFinalDestination() {
        return this.swaggerUiFinalDestination;
    }

    public void setSwaggerUiFinalDestination(String swaggerUiFinalDestination) {
        this.swaggerUiFinalDestination = swaggerUiFinalDestination;
    }

    public String getSwaggerUiPath() {
        return this.swaggerUiPath;
    }

    public void setSwaggerUiPath(String swaggerUiPath) {
        this.swaggerUiPath = swaggerUiPath;
    }

    @Override
    public void handle(RoutingContext event) {
        StaticHandler staticHandler = StaticHandler.create().setAllowRootFileSystemAccess(true).setWebRoot(this.swaggerUiFinalDestination).setDefaultContentEncoding("UTF-8");
        if (event.normalizedPath().length() == this.swaggerUiPath.length()) {
            event.response().setStatusCode(302);
            event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)(this.swaggerUiPath + "/"));
            event.response().end();
            return;
        }
        if (event.normalizedPath().length() == this.swaggerUiPath.length() + 1) {
            event.reroute(this.swaggerUiPath + "/index.html");
            return;
        }
        staticHandler.handle(event);
    }
}

