/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventContext;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.impl.CloudEventContextReaderAdapter;
import io.cloudevents.core.impl.CloudEventReaderAdapter;
import io.cloudevents.lang.Nullable;
import io.cloudevents.rw.CloudEventContextReader;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;

public final class CloudEventUtils {
    private CloudEventUtils() {
    }

    public static CloudEventReader toReader(CloudEvent event) {
        if (event instanceof CloudEventReader) {
            return (CloudEventReader)((Object)event);
        }
        return new CloudEventReaderAdapter(event);
    }

    public static CloudEventContextReader toContextReader(CloudEventContext event) {
        if (event instanceof CloudEventContextReader) {
            return (CloudEventContextReader)((Object)event);
        }
        return new CloudEventContextReaderAdapter(event);
    }

    public static CloudEvent toEvent(CloudEventReader reader) throws CloudEventRWException {
        return CloudEventUtils.toEvent(reader, CloudEventDataMapper.identity());
    }

    public static CloudEvent toEvent(CloudEventReader reader, CloudEventDataMapper<?> mapper) throws CloudEventRWException {
        return (CloudEvent)reader.read(CloudEventBuilder::fromSpecVersion, mapper);
    }

    @Nullable
    public static <R extends CloudEventData> R mapData(CloudEvent event, CloudEventDataMapper<R> mapper) {
        CloudEventData data = event.getData();
        if (data == null) {
            return null;
        }
        return mapper.map(data);
    }
}

