/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.inmemory.postgresql.runtime;

import java.util.Collections;
import java.util.HashMap;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.kie.kogito.persistence.inmemory.postgresql.runtime.InmemoryPostgreSQLConfigSource;

public class InmemoryPostgreSQLConfigSourceProvider
implements ConfigSourceProvider {
    static final String QUARKUS_DATASOURCE_REACTIVE_URL = "quarkus.datasource.reactive.url";
    static final String QUARKUS_DATASOURCE_JDBC_URL = "quarkus.datasource.jdbc.url";
    static final String QUARKUS_DATASOURCE_USERNAME = "quarkus.datasource.username";
    static final String QUARKUS_DATASOURCE_PASSWORD = "quarkus.datasource.password";
    static final String DEFAULT_DATABASE = "postgres";
    static final String DEFAULT_REACTIVE_URL = "postgresql://localhost:%d/postgres";
    static final String DEFAULT_JDBC_URL = "jdbc:postgresql://localhost:%d/postgres";
    static final String DEFAULT_USERNAME = "postgres";
    static final String DEFAULT_PASSWORD = "postgres";
    private final int port;

    public InmemoryPostgreSQLConfigSourceProvider(int port) {
        this.port = port;
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(QUARKUS_DATASOURCE_REACTIVE_URL, String.format(DEFAULT_REACTIVE_URL, this.port));
        properties.put(QUARKUS_DATASOURCE_JDBC_URL, String.format(DEFAULT_JDBC_URL, this.port));
        properties.put(QUARKUS_DATASOURCE_USERNAME, "postgres");
        properties.put(QUARKUS_DATASOURCE_PASSWORD, "postgres");
        return Collections.singleton(new InmemoryPostgreSQLConfigSource(properties));
    }
}

