/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.inmemory.postgresql.it;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.pgclient.PgPool;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.kogito.persistence.inmemory.postgresql.it.InmemoryPostgreSQL;

@Path(value="inmemory-postgresql")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class InmemoryPostgreSQLResource {
    private final PgPool client;

    public InmemoryPostgreSQLResource(PgPool client) {
        this.client = client;
    }

    @GET
    public Multi<InmemoryPostgreSQL> get() {
        return InmemoryPostgreSQL.findAll(this.client);
    }

    @GET
    @Path(value="{id}")
    public Uni<Response> getSingle(Long id) {
        return InmemoryPostgreSQL.findById(this.client, id).onItem().transform(inmemoryPostgreSQL -> inmemoryPostgreSQL != null ? Response.ok((Object)inmemoryPostgreSQL) : Response.status((Response.Status)Response.Status.NOT_FOUND)).onItem().transform(Response.ResponseBuilder::build);
    }

    @POST
    public Uni<Response> create(InmemoryPostgreSQL inmemoryPostgreSQL) {
        return inmemoryPostgreSQL.save(this.client).onItem().transform(id -> URI.create("/inmemory_postgresql/" + id)).onItem().transform(uri -> Response.created((URI)uri).build());
    }

    @PUT
    @Path(value="{id}")
    public Uni<Response> update(Long id, InmemoryPostgreSQL inmemoryPostgreSQL) {
        return inmemoryPostgreSQL.update(this.client).onItem().transform(updated -> updated != false ? Response.Status.OK : Response.Status.NOT_FOUND).onItem().transform(status -> Response.status((Response.Status)status).build());
    }

    @DELETE
    @Path(value="{id}")
    public Uni<Response> delete(Long id) {
        return InmemoryPostgreSQL.delete(this.client, id).onItem().transform(deleted -> deleted != false ? Response.Status.NO_CONTENT : Response.Status.NOT_FOUND).onItem().transform(status -> Response.status((Response.Status)status).build());
    }
}

