/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.inmemory.postgresql.test;

import io.quarkus.test.QuarkusUnitTest;
import io.smallrye.mutiny.Multi;
import io.vertx.mutiny.pgclient.PgPool;
import io.vertx.mutiny.sqlclient.Tuple;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class InmemoryPostgreSQLTest {
    @RegisterExtension
    static final QuarkusUnitTest unitTest = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource("db/migration/V1.0.0__Inmemory_PostgreSQL.sql")).withConfigurationResource("application.properties");
    @Inject
    PgPool client;

    @Test
    public void testFlyway() {
        List<String> results = this.select(1);
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertEquals((Object)"test1", (Object)results.get(0));
    }

    @Test
    public void testCRUD() {
        List<String> results = this.select(2);
        Assertions.assertEquals((int)0, (int)results.size());
        this.insert(2, "test2");
        results = this.select(2);
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertEquals((Object)"test2", (Object)results.get(0));
        this.update(2, "test2_update");
        results = this.select(2);
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertEquals((Object)"test2_update", (Object)results.get(0));
        this.delete(2);
        results = this.select(2);
        Assertions.assertEquals((int)0, (int)results.size());
    }

    private List<String> select(int id) {
        return (List)this.client.preparedQuery("SELECT name FROM inmemory_postgresql WHERE id = $1").execute(Tuple.of((Object)id)).onItem().transformToMulti(rowSet -> Multi.createFrom().iterable((Iterable)rowSet)).onItem().transform(row -> row.getString("name")).collect().asList().await().atMost(Duration.ofSeconds(10L));
    }

    private void insert(int id, String name) {
        this.client.preparedQuery("INSERT INTO inmemory_postgresql(id, name) VALUES ($1, $2)").execute(Tuple.tuple(Stream.of(Integer.valueOf(id), name).collect(Collectors.toList()))).await().atMost(Duration.ofSeconds(10L));
    }

    private void update(int id, String name) {
        this.client.preparedQuery("UPDATE inmemory_postgresql SET name = $2 WHERE id = $1").execute(Tuple.tuple(Stream.of(Integer.valueOf(id), name).collect(Collectors.toList()))).await().atMost(Duration.ofSeconds(10L));
    }

    private void delete(int id) {
        this.client.preparedQuery("DELETE FROM inmemory_postgresql WHERE id = $1").execute(Tuple.tuple(Stream.of(Integer.valueOf(id)).collect(Collectors.toList()))).await().atMost(Duration.ofSeconds(10L));
    }
}

