/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels.usertasks;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.acme.travels.usertasks.CompleteStartedOnly;
import org.acme.travels.usertasks.Start;
import org.jbpm.process.instance.impl.humantask.BaseHumanTaskLifeCycle;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemImpl;
import org.jbpm.process.instance.impl.humantask.phases.Claim;
import org.jbpm.process.instance.impl.humantask.phases.Release;
import org.jbpm.process.instance.impl.humantask.phases.Skip;
import org.jbpm.process.instance.impl.workitem.Abort;
import org.jbpm.process.instance.impl.workitem.Active;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.kogito.process.workitem.InvalidLifeCyclePhaseException;
import org.kie.kogito.process.workitem.InvalidTransitionException;
import org.kie.kogito.process.workitem.LifeCycle;
import org.kie.kogito.process.workitem.LifeCyclePhase;
import org.kie.kogito.process.workitem.NotAuthorizedException;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHumanTaskLifeCycle
implements LifeCycle<Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(BaseHumanTaskLifeCycle.class);
    private Map<String, LifeCyclePhase> phases = new LinkedHashMap();

    public CustomHumanTaskLifeCycle() {
        this.phases.put("claim", new Claim());
        this.phases.put("release", new Release());
        this.phases.put("start", new Start());
        this.phases.put("complete", new CompleteStartedOnly());
        this.phases.put("skip", new Skip());
        this.phases.put("active", new Active());
        this.phases.put("abort", new Abort());
    }

    public LifeCyclePhase phaseById(String phaseId) {
        return (LifeCyclePhase)this.phases.get(phaseId);
    }

    public Collection<LifeCyclePhase> phases() {
        return this.phases.values();
    }

    public Map<String, Object> transitionTo(WorkItem workItem, WorkItemManager manager, Transition<Map<String, Object>> transition) {
        logger.debug("Transition method invoked for work item {} to transition to {}, currently in phase {} and status {}", new Object[]{workItem.getId(), transition.phase(), workItem.getPhaseId(), workItem.getPhaseStatus()});
        HumanTaskWorkItemImpl humanTaskWorkItem = (HumanTaskWorkItemImpl)workItem;
        LifeCyclePhase targetPhase = (LifeCyclePhase)this.phases.get(transition.phase());
        if (targetPhase == null) {
            logger.debug("Target life cycle phase '{}' does not exist in {}", (Object)transition.phase(), (Object)this.getClass().getSimpleName());
            throw new InvalidLifeCyclePhaseException(transition.phase());
        }
        LifeCyclePhase currentPhase = (LifeCyclePhase)this.phases.get(humanTaskWorkItem.getPhaseId());
        if (!targetPhase.canTransition(currentPhase)) {
            logger.debug("Target life cycle phase '{}' cannot transition from current state '{}'", (Object)targetPhase.id(), (Object)currentPhase.id());
            throw new InvalidTransitionException("Cannot transition from " + humanTaskWorkItem.getPhaseId() + " to " + targetPhase.id());
        }
        if (!(targetPhase.id().equals("active") || targetPhase.id().equals("abort") || humanTaskWorkItem.enforce(transition.policies().toArray(new Policy[transition.policies().size()])))) {
            throw new NotAuthorizedException("User is not authorized to access task instance with id " + humanTaskWorkItem.getId());
        }
        humanTaskWorkItem.setPhaseId(targetPhase.id());
        humanTaskWorkItem.setPhaseStatus(targetPhase.status());
        targetPhase.apply((WorkItem)humanTaskWorkItem, transition);
        if (transition.data() != null) {
            logger.debug("Updating data for work item {}", (Object)targetPhase.id(), (Object)humanTaskWorkItem.getId());
            humanTaskWorkItem.getResults().putAll((Map)transition.data());
        }
        logger.debug("Transition for work item {} to {} done, currently in phase {} and status {}", new Object[]{workItem.getId(), transition.phase(), workItem.getPhaseId(), workItem.getPhaseStatus()});
        if (targetPhase.isTerminating()) {
            logger.debug("Target life cycle phase '{}' is terminiating, completing work item {}", (Object)targetPhase.id(), (Object)humanTaskWorkItem.getId());
            ((org.drools.core.process.instance.WorkItemManager)manager).internalCompleteWorkItem((org.drools.core.process.instance.WorkItem)humanTaskWorkItem);
        }
        return this.data((WorkItem)humanTaskWorkItem);
    }

    public Map<String, Object> data(WorkItem workItem) {
        return ((HumanTaskWorkItemImpl)workItem).getResults();
    }
}

