/*
 * Decompiled with CFR 0.152.
 */
package org.acme.deals;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.acme.deals.DealsModel;
import org.acme.deals.DealsModelInput;
import org.acme.deals.DealsModelOutput;
import org.acme.deals.Deals_TaskModelFactory;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.workitem.TaskModel;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/deals"})
@Component
public class DealsResource {
    @Autowired
    @Qualifier(value="deals")
    Process<DealsModel> process;
    @Autowired
    Application application;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<DealsModelOutput> createResource_deals(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull DealsModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            DealsModelInput inputModel = resource != null ? resource : new DealsModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            List startFromNode = httpHeaders.get((Object)"X-KOGITO-StartFromNode");
            if (startFromNode != null && !startFromNode.isEmpty()) {
                pi.startFrom((String)startFromNode.get(0));
            } else {
                pi.start();
            }
            UriComponents uriComponents = uriComponentsBuilder.path("/deals/{id}").buildAndExpand(new Object[]{pi.id()});
            URI location = uriComponents.toUri();
            return ResponseEntity.created((URI)location).body((Object)((DealsModel)pi.checkError().variables()).toOutput());
        });
    }

    @GetMapping(produces={"application/json"})
    public List<DealsModelOutput> getResources_deals() {
        return this.process.instances().values().stream().map(pi -> ((DealsModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<DealsModelOutput> getResource_deals(@PathVariable(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(m -> ResponseEntity.ok((Object)((DealsModel)m.variables()).toOutput())).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<DealsModelOutput> deleteResource_deals(@PathVariable(value="id") String id) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((DealsModel)pi.checkError().variables()).toOutput();
        }).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<DealsModelOutput> updateModel_deals(@PathVariable(value="id") String id, @RequestBody(required=false) DealsModel resource) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((DealsModel)pi.updateVariables((Object)resource)).toOutput()).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    public ResponseEntity<List<TaskModel>> getTasks_deals(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of((String)user, (Collection)groups)).stream().map(Deals_TaskModelFactory::from).collect(Collectors.toList())).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }
}

