package org.kie.kogito.app;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.kie.kogito.event.CloudEventMeta;
import org.kie.kogito.services.event.TopicDiscovery;

@Path("/messaging/topics")
@org.springframework.stereotype.Component()
public class TopicsInformationResource {

    @org.springframework.beans.factory.annotation.Autowired()
    TopicDiscovery discovery;

    private List<CloudEventMeta> eventsMeta;

    public TopicsInformationResource() {
        eventsMeta = new ArrayList<>();
        eventsMeta.add(new CloudEventMeta("travellers", "", org.kie.kogito.event.EventKind.CONSUMED));
        eventsMeta.add(new CloudEventMeta("process.travelers.processedtravellers", "/process/travelers", org.kie.kogito.event.EventKind.PRODUCED));
    }

    @GET()
    @Produces(MediaType.APPLICATION_JSON)
    public javax.ws.rs.core.Response getTopics() {
        return javax.ws.rs.core.Response.ok(discovery.getTopics(eventsMeta)).build();
    }
}
