/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.BaseSqlBuilderImplTest;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTriggerDeleteSqlBuilder;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PostgresTriggerDeleteSqlBuilderTest
extends BaseSqlBuilderImplTest {
    private final PostgresTriggerDeleteSqlBuilder triggerDeleteSqlBuilder = new PostgresTriggerDeleteSqlBuilder();

    PostgresTriggerDeleteSqlBuilderTest() {
    }

    @Override
    protected PostgresTriggerDeleteSqlBuilder getTriggerDeleteBuilder() {
        return this.triggerDeleteSqlBuilder;
    }

    @Override
    protected String getCreateSql(PostgresContext context) {
        return this.getTriggerDeleteBuilder().createDeleteTriggerSql(context);
    }

    @Override
    protected String getDestroySql(PostgresContext context) {
        return this.getTriggerDeleteBuilder().dropDeleteTriggerSql(context);
    }

    @Override
    protected void assertCreateSql(String sql) {
        Assertions.assertNotNull((Object)sql);
        this.assertSequentialContent(sql, "CREATE TRIGGER trgDelete_mappingId_DELETES AFTER DELETE ON sourceTableName", "FOR EACH ROW", "EXECUTE PROCEDURE spDelete_mappingId_DELETES()", "CREATE TRIGGER trgDelete_mappingId_UPDATES BEFORE UPDATE ON sourceTableName", "FOR EACH ROW", "EXECUTE PROCEDURE spDelete_mappingId_UPDATES()");
    }

    @Override
    protected void assertDestroySql(String sql) {
        Assertions.assertNotNull((Object)sql);
        this.assertSequentialContent(sql, "DROP TRIGGER IF EXISTS trgDelete_mappingId_DELETES ON sourceTableName", "DROP TRIGGER IF EXISTS trgDelete_mappingId_UPDATES ON sourceTableName");
    }

    @Test
    void testCreateDeleteTriggerFunctionSql() {
        PostgresContext context = this.manager.createContext(DEFINITION);
        String sql = this.getTriggerDeleteBuilder().createDeleteTriggerFunctionSql(context);
        Assertions.assertNotNull((Object)sql);
        this.assertSequentialContent(sql, "CREATE FUNCTION spDelete_mappingId_DELETES() RETURNS trigger AS", "DELETE FROM targetTableName", "WHERE", "id = OLD.id", "RETURN OLD;", "CREATE FUNCTION spDelete_mappingId_UPDATES() RETURNS trigger AS", "DELETE FROM targetTableName", "WHERE", "id = NEW.id", "RETURN NEW;");
    }

    @Test
    void testDropDeleteTriggerFunctionSql() {
        PostgresContext context = this.manager.createContext(DEFINITION);
        String sql = this.getTriggerDeleteBuilder().dropDeleteTriggerFunctionSql(context);
        Assertions.assertNotNull((Object)sql);
        this.assertSequentialContent(sql, "DROP FUNCTION IF EXISTS spDelete_mappingId_DELETES", "DROP FUNCTION IF EXISTS spDelete_mappingId_UPDATES");
    }
}

