/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.service;

import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.postgresql.PostgresStorageService;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresJsonField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMappingDefinition;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.postgresql.reporting.service.PostgresMappingServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PostgresMappingServiceImplTest {
    @Mock
    private PostgresStorageService storageService;
    @Mock
    private Storage<String, PostgresMappingDefinition> storage;
    private PostgresMappingServiceImpl service;

    PostgresMappingServiceImplTest() {
    }

    @BeforeEach
    public void setup() {
        this.service = new PostgresMappingServiceImpl(this.storageService);
        Mockito.when((Object)this.storageService.getCache("MappingDefinitions", PostgresMappingDefinition.class)).thenReturn(this.storage);
    }

    @Test
    void testGetAllMappingDefinitions() {
        PostgresMappingDefinition definition = new PostgresMappingDefinition("mappingId", "sourceTableName", "sourceTableJsonFieldName", List.of(new PostgresField("key")), List.of(new PostgresPartitionField("sourceTablePartitionFieldName", "sourceTablePartitionName")), "targetTableName", List.of(new PostgresMapping("sourceJsonPath", new PostgresJsonField("targetFieldName", JsonType.STRING))));
        Mockito.when((Object)this.storage.entries()).thenReturn(Map.of("mappingId", definition));
        List definitions = this.service.getAllMappingDefinitions();
        Assertions.assertEquals((int)1, (int)definitions.size());
        Assertions.assertEquals((Object)definition, definitions.get(0));
    }

    @Test
    void testGetMappingDefinitionByIdWhenFound() {
        PostgresMappingDefinition definition = new PostgresMappingDefinition("mappingId", "sourceTableName", "sourceTableJsonFieldName", List.of(new PostgresField("key")), List.of(new PostgresPartitionField("sourceTablePartitionFieldName", "sourceTablePartitionName")), "targetTableName", List.of(new PostgresMapping("sourceJsonPath", new PostgresJsonField("targetFieldName", JsonType.STRING))));
        Mockito.when((Object)this.storage.containsKey((Object)ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)((PostgresMappingDefinition)this.storage.get((Object)ArgumentMatchers.anyString()))).thenReturn((Object)definition);
        PostgresMappingDefinition result = this.service.getMappingDefinitionById("mappingId");
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)definition, (Object)result);
    }

    @Test
    void testGetMappingDefinitionByIdWhenNotFound() {
        Mockito.when((Object)this.storage.containsKey((Object)ArgumentMatchers.anyString())).thenReturn((Object)false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.service.getMappingDefinitionById("mappingId"));
    }

    @Test
    void testSaveMappingDefinitionWhenAlreadyExists() {
        PostgresMappingDefinition definition = new PostgresMappingDefinition("mappingId", "sourceTableName", "sourceTableJsonFieldName", List.of(new PostgresField("key")), List.of(new PostgresPartitionField("sourceTablePartitionFieldName", "sourceTablePartitionName")), "targetTableName", List.of(new PostgresMapping("sourceJsonPath", new PostgresJsonField("targetFieldName", JsonType.STRING))));
        Mockito.when((Object)this.storage.containsKey((Object)ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.service.saveMappingDefinition(definition));
    }

    @Test
    void testSaveMappingDefinitionWhenNotAlreadyExists() {
        PostgresMappingDefinition definition = new PostgresMappingDefinition("mappingId", "sourceTableName", "sourceTableJsonFieldName", List.of(new PostgresField("key")), List.of(new PostgresPartitionField("sourceTablePartitionFieldName", "sourceTablePartitionName")), "targetTableName", List.of(new PostgresMapping("sourceJsonPath", new PostgresJsonField("targetFieldName", JsonType.STRING))));
        Mockito.when((Object)this.storage.containsKey((Object)ArgumentMatchers.anyString())).thenReturn((Object)false);
        this.service.saveMappingDefinition(definition);
        ((Storage)Mockito.verify(this.storage)).put((Object)"mappingId", (Object)definition);
    }

    @Test
    void testDeleteMappingDefinitionByIdWhenFound() {
        PostgresMappingDefinition definition = new PostgresMappingDefinition("mappingId", "sourceTableName", "sourceTableJsonFieldName", List.of(new PostgresField("key")), List.of(new PostgresPartitionField("sourceTablePartitionFieldName", "sourceTablePartitionName")), "targetTableName", List.of(new PostgresMapping("sourceJsonPath", new PostgresJsonField("targetFieldName", JsonType.STRING))));
        Mockito.when((Object)this.storage.containsKey((Object)ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)((PostgresMappingDefinition)this.storage.remove((Object)ArgumentMatchers.anyString()))).thenReturn((Object)definition);
        PostgresMappingDefinition deleted = this.service.deleteMappingDefinitionById("mappingId");
        Assertions.assertEquals((Object)definition, (Object)deleted);
        ((Storage)Mockito.verify(this.storage)).remove((Object)"mappingId");
    }

    @Test
    void testDeleteMappingDefinitionByIdWhenNotFound() {
        Mockito.when((Object)this.storage.containsKey((Object)ArgumentMatchers.anyString())).thenReturn((Object)false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.service.deleteMappingDefinitionById("mappingId"));
    }
}

