/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.postgresql.PostgresStorageService;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresJsonField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMappingDefinition;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.reporting.service.MappingService;

@ApplicationScoped
public class PostgresMappingServiceImpl
implements MappingService<JsonType, PostgresField, PostgresPartitionField, PostgresJsonField, PostgresMapping, PostgresMappingDefinition> {
    static final String CACHE_NAME = "MappingDefinitions";
    private final PostgresStorageService storageService;

    @Inject
    public PostgresMappingServiceImpl(PostgresStorageService storageService) {
        this.storageService = Objects.requireNonNull(storageService);
    }

    public List<PostgresMappingDefinition> getAllMappingDefinitions() {
        ArrayList mappingDefinitions = new ArrayList(this.storageService.getCache(CACHE_NAME, PostgresMappingDefinition.class).entries().values());
        return Collections.unmodifiableList(mappingDefinitions);
    }

    public PostgresMappingDefinition getMappingDefinitionById(String mappingId) {
        Storage storage = this.storageService.getCache(CACHE_NAME, PostgresMappingDefinition.class);
        if (!storage.containsKey((Object)mappingId)) {
            throw new IllegalArgumentException(String.format("A MappingDefinition with ID '%s' cannot be found in the storage.", mappingId));
        }
        return (PostgresMappingDefinition)((Object)storage.get((Object)mappingId));
    }

    @Transactional
    public void saveMappingDefinition(PostgresMappingDefinition definition) {
        String mappingId = definition.getMappingId();
        Storage storage = this.storageService.getCache(CACHE_NAME, PostgresMappingDefinition.class);
        if (storage.containsKey((Object)mappingId)) {
            throw new IllegalArgumentException(String.format("A MappingDefinition with ID '%s' is already present in the storage.", mappingId));
        }
        storage.put((Object)mappingId, (Object)definition);
    }

    @Transactional
    public PostgresMappingDefinition deleteMappingDefinitionById(String mappingId) {
        Storage storage = this.storageService.getCache(CACHE_NAME, PostgresMappingDefinition.class);
        if (!storage.containsKey((Object)mappingId)) {
            throw new IllegalArgumentException(String.format("A MappingDefinition with ID '%s' cannot be found in the storage.", mappingId));
        }
        return (PostgresMappingDefinition)((Object)storage.remove((Object)mappingId));
    }
}

