/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.BaseSqlBuilderImplTest;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTriggerInsertSqlBuilder;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PostgresTriggerInsertSqlBuilderTest
extends BaseSqlBuilderImplTest {
    private final PostgresTriggerInsertSqlBuilder triggerInsertSqlBuilder = new PostgresTriggerInsertSqlBuilder();

    PostgresTriggerInsertSqlBuilderTest() {
    }

    @Override
    protected PostgresTriggerInsertSqlBuilder getTriggerInsertBuilder() {
        return this.triggerInsertSqlBuilder;
    }

    @Override
    protected String getCreateSql(PostgresContext context) {
        return this.getTriggerInsertBuilder().createInsertTriggerSql(context);
    }

    @Override
    protected String getDestroySql(PostgresContext context) {
        return this.getTriggerInsertBuilder().dropInsertTriggerSql(context);
    }

    @Override
    protected void assertCreateSql(String sql) {
        Assertions.assertNotNull((Object)sql);
        this.assertSequentialContent(sql, "CREATE TRIGGER trgInsert_mappingId AFTER INSERT OR UPDATE ON sourceTableName", "FOR EACH ROW", "EXECUTE PROCEDURE spInsert_mappingId()");
    }

    @Override
    protected void assertDestroySql(String sql) {
        Assertions.assertNotNull((Object)sql);
        this.assertSequentialContent(sql, "DROP TRIGGER IF EXISTS trgInsert_mappingId ON sourceTableName");
    }

    @Test
    void testCreateInsertTriggerFunctionSql() {
        PostgresContext context = this.manager.createContext(DEFINITION);
        String sql = this.getTriggerInsertBuilder().createInsertTriggerFunctionSql(context);
        Assertions.assertNotNull((Object)sql);
        this.assertSequentialContent(sql, "CREATE FUNCTION spInsert_mappingId() RETURNS trigger A", "INSERT INTO targetTableName", "SELECT", "NEW.id", "(NEW.sourceTableJsonFieldName->>'root')\\:\\:text as field1", "(NEW.sourceTableJsonFieldName->'root'->>'child')\\:\\:text as field2", "(g0->>'child')\\:\\:text as field3", "(NEW.sourceTableJsonFieldName->'root'->'child'->>'sibling')\\:\\:text as field4", "FROM", "  jsonb_array_elements(", "case jsonb_typeof(NEW.sourceTableJsonFieldName->'collection')", "when 'array' then NEW.sourceTableJsonFieldName->'collection'", "else jsonb_build_array(NEW.sourceTableJsonFieldName->'collection')", "end", ") g0");
    }

    @Test
    void testDropInsertTriggerFunctionSql() {
        PostgresContext context = this.manager.createContext(DEFINITION);
        String sql = this.getTriggerInsertBuilder().dropInsertTriggerFunctionSql(context);
        Assertions.assertNotNull((Object)sql);
        this.assertSequentialContent(sql, "DROP FUNCTION IF EXISTS spInsert_mappingId");
    }
}

