/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresJsonField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.IndexesSqlBuilder;
import org.kie.kogito.persistence.reporting.model.paths.PathSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PostgresIndexesSqlBuilder
implements IndexesSqlBuilder<JsonType, PostgresField, PostgresPartitionField, PostgresJsonField, PostgresMapping, PostgresContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresIndexesSqlBuilder.class);
    private static final String CREATE_INDEX_TEMPLATE = "CREATE INDEX idx_%s ON %s USING gin ((%s->%s)); %n";
    private static final String INDEX_PATH_SEGMENT_TEMPLATE = "'%s'";
    private static final String DROP_INDEX_TEMPLATE = "DROP INDEX IF EXISTS idx_%s; %n";

    public String createTableIndexesSql(PostgresContext context) {
        int[] idxCount = new int[]{0};
        String sourceTableName = context.getSourceTableName();
        String sourceTableJsonFieldName = context.getSourceTableJsonFieldName();
        String targetTableName = context.getTargetTableName();
        List mappingPaths = context.getMappingPaths();
        StringBuilder sql = new StringBuilder();
        for (PathSegment mappingPath : mappingPaths) {
            PostgresIndexesSqlBuilder.addIndexSegment(mappingPath, new ArrayList<String>(), segments -> {
                Object[] objectArray = new Object[4];
                int n = idxCount[0];
                idxCount[0] = n + 1;
                objectArray[0] = targetTableName + "_" + n;
                objectArray[1] = sourceTableName;
                objectArray[2] = sourceTableJsonFieldName;
                objectArray[3] = String.join((CharSequence)"->", segments);
                sql.append(String.format(CREATE_INDEX_TEMPLATE, objectArray));
            });
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Create TABLE INDEXES SQL:%n%s", sql));
        }
        return sql.toString();
    }

    public String dropTableIndexesSql(PostgresContext context) {
        int[] idxCount = new int[]{0};
        String targetTableName = context.getTargetTableName();
        List mappingPaths = context.getMappingPaths();
        StringBuilder sql = new StringBuilder();
        for (PathSegment mappingPath : mappingPaths) {
            PostgresIndexesSqlBuilder.addIndexSegment(mappingPath, new ArrayList<String>(), segments -> {
                Object[] objectArray = new Object[1];
                int n = idxCount[0];
                idxCount[0] = n + 1;
                objectArray[0] = targetTableName + "_" + n;
                sql.append(String.format(DROP_INDEX_TEMPLATE, objectArray));
            });
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Drop TABLE INDEXES SQL:%n%s", sql));
        }
        return sql.toString();
    }

    private static void addIndexSegment(PathSegment path, List<String> segments, Consumer<List<String>> consumer) {
        String sanitizedSegment = path.getSegment().replace("[]", "");
        segments.add(String.format(INDEX_PATH_SEGMENT_TEMPLATE, sanitizedSegment));
        consumer.accept(segments);
        path.getChildren().forEach(child -> PostgresIndexesSqlBuilder.addIndexSegment(child, new ArrayList<String>(segments), consumer));
    }
}

