/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityResult;
import javax.persistence.FieldResult;
import javax.persistence.Id;
import javax.persistence.Query;
import javax.persistence.SqlResultSetMapping;
import javax.transaction.Transactional;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresApplyMappingSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresIndexesSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTableSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTriggerDeleteSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTriggerInsertSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresJsonField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMappingDefinition;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.postgresql.reporting.model.paths.PostgresTerminalPathSegment;
import org.kie.kogito.persistence.reporting.database.BaseDatabaseManagerImpl;
import org.kie.kogito.persistence.reporting.database.Validations;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.ApplyMappingSqlBuilder;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.IndexesSqlBuilder;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.TableSqlBuilder;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.TriggerDeleteSqlBuilder;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.TriggerInsertSqlBuilder;
import org.kie.kogito.persistence.reporting.model.MappingDefinition;
import org.kie.kogito.persistence.reporting.model.paths.PathSegment;
import org.kie.kogito.persistence.reporting.model.paths.TerminalPathSegment;

public abstract class BasePostgresDatabaseManagerImpl
extends BaseDatabaseManagerImpl<JsonType, PostgresField, PostgresPartitionField, PostgresJsonField, PostgresMapping, PostgresMappingDefinition, PostgresContext> {
    private static final String COLUMN_INFO = "SELECT column_name, udt_name FROM information_schema.columns WHERE table_name = '%s';";

    protected BasePostgresDatabaseManagerImpl() {
    }

    protected BasePostgresDatabaseManagerImpl(PostgresIndexesSqlBuilder indexesSqlBuilder, PostgresTableSqlBuilder tableSqlBuilder, PostgresTriggerDeleteSqlBuilder triggerDeleteSqlBuilder, PostgresTriggerInsertSqlBuilder triggerInsertSqlBuilder, PostgresApplyMappingSqlBuilder applyMappingSqlBuilder) {
        super((IndexesSqlBuilder)indexesSqlBuilder, (TableSqlBuilder)tableSqlBuilder, (TriggerDeleteSqlBuilder)triggerDeleteSqlBuilder, (TriggerInsertSqlBuilder)triggerInsertSqlBuilder, (ApplyMappingSqlBuilder)applyMappingSqlBuilder);
    }

    protected TerminalPathSegment<JsonType, PostgresJsonField, PostgresMapping> buildTerminalPathSegment(String segment, PathSegment parent, PostgresMapping mapping) {
        return new PostgresTerminalPathSegment(segment, parent, mapping);
    }

    public PostgresContext createContext(PostgresMappingDefinition mappingDefinition) {
        String mappingId = Validations.validateMappingId((String)mappingDefinition.getMappingId());
        String sourceTableName = Validations.validateSourceTableName((String)mappingDefinition.getSourceTableName());
        String sourceTableJsonFieldName = Validations.validateSourceTableJsonFieldName((String)mappingDefinition.getSourceTableJsonFieldName());
        List sourceTableIdentityFields = Validations.validateSourceTableIdentityFields((List)mappingDefinition.getSourceTableIdentityFields());
        List sourceTablePartitionFields = Validations.validateSourceTablePartitionFields((List)mappingDefinition.getSourceTablePartitionFields());
        String targetTableName = Validations.validateTargetTableName((String)mappingDefinition.getTargetTableName());
        List mappings = Validations.validateFieldMappings((List)mappingDefinition.getFieldMappings());
        List pathSegments = this.parsePathSegments(mappings);
        Map<String, String> sourceTableFieldTypes = this.getSourceTableFieldTypes(sourceTableName);
        return new PostgresContext(mappingId, sourceTableName, sourceTableJsonFieldName, sourceTableIdentityFields, sourceTablePartitionFields, targetTableName, mappings, pathSegments, sourceTableFieldTypes);
    }

    protected Map<String, String> getSourceTableFieldTypes(String sourceTableName) {
        EntityManager em = this.getEntityManager(sourceTableName);
        Query query = em.createNativeQuery(String.format(COLUMN_INFO, sourceTableName), "ColumnInformationMapping");
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(i -> i.name, i -> i.type));
    }

    @Transactional
    public void createArtifacts(PostgresMappingDefinition mappingDefinition) {
        super.createArtifacts((MappingDefinition)mappingDefinition);
    }

    @Transactional
    public void destroyArtifacts(PostgresMappingDefinition mappingDefinition) {
        super.destroyArtifacts((MappingDefinition)mappingDefinition);
    }

    @Entity
    @SqlResultSetMapping(name="ColumnInformationMapping", entities={@EntityResult(entityClass=ColumnInformationRow.class, fields={@FieldResult(name="name", column="column_name"), @FieldResult(name="type", column="udt_name")})})
    public static class ColumnInformationRow {
        @Id
        @Column(nullable=false)
        private String name;
        @Column
        private String type;
    }
}

