/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.BaseSqlBuilderImplTest;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresIndexesSqlBuilder;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PostgresIndexesSqlBuilderTest
extends BaseSqlBuilderImplTest {
    private final PostgresIndexesSqlBuilder indexesSqlBuilder = new PostgresIndexesSqlBuilder();

    PostgresIndexesSqlBuilderTest() {
    }

    @Override
    protected PostgresIndexesSqlBuilder getIndexesBuilder() {
        return this.indexesSqlBuilder;
    }

    @Override
    protected String getCreateSql(PostgresContext context) {
        return this.getIndexesBuilder().createTableIndexesSql(context);
    }

    @Override
    protected String getDestroySql(PostgresContext context) {
        return this.getIndexesBuilder().dropTableIndexesSql(context);
    }

    @Override
    protected void assertCreateSql(String sql) {
        Assertions.assertNotNull((Object)sql);
        this.assertSequentialContent(sql, "CREATE INDEX idx_targetTableName_0", "sourceTableJsonFieldName->'root'", "CREATE INDEX idx_targetTableName_1", "sourceTableJsonFieldName->'root'->'child'", "CREATE INDEX idx_targetTableName_2", "sourceTableJsonFieldName->'root'->'child'->'collection'", "CREATE INDEX idx_targetTableName_3", "sourceTableJsonFieldName->'root'->'child'->'collection'->'child'", "CREATE INDEX idx_targetTableName_4", "sourceTableJsonFieldName->'root'->'child'->'sibling'");
    }

    @Override
    protected void assertDestroySql(String sql) {
        Assertions.assertNotNull((Object)sql);
        this.assertSequentialContent(sql, "DROP INDEX IF EXISTS idx_targetTableName_0", "DROP INDEX IF EXISTS idx_targetTableName_1", "DROP INDEX IF EXISTS idx_targetTableName_2", "DROP INDEX IF EXISTS idx_targetTableName_3", "DROP INDEX IF EXISTS idx_targetTableName_4");
    }
}

