/*
 * Copyright 2022 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.persistence.postgresql.reporting.model;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotEquals;

class PostgresMappingTest {

    static final PostgresMapping MAPPING = new PostgresMapping("sourceJsonPath", PostgresJsonFieldTest.FIELD);
    static final int MAPPING_HASHCODE = MAPPING.hashCode();

    @Test
    void testEquality() {
        assertEquals(MAPPING,
                MAPPING);
        assertNotEquals(MAPPING,
                new PostgresMapping("different",
                        new PostgresJsonField("field1", JsonType.STRING)));
        assertNotEquals(MAPPING,
                new PostgresMapping("sourceJsonPath",
                        new PostgresJsonField("field1", JsonType.NUMBER)));
        assertNotEquals(MAPPING,
                new PostgresMapping("sourceJsonPath",
                        new PostgresJsonField("field2", JsonType.STRING)));
    }

    @Test
    void testHashCode() {
        assertEquals(MAPPING_HASHCODE,
                MAPPING.hashCode());
        assertNotEquals(MAPPING_HASHCODE,
                new PostgresMapping("different",
                        new PostgresJsonField("field1", JsonType.STRING)).hashCode());
        assertNotEquals(MAPPING_HASHCODE,
                new PostgresMapping("sourceJsonPath",
                        new PostgresJsonField("field1", JsonType.NUMBER)).hashCode());
        assertNotEquals(MAPPING_HASHCODE,
                new PostgresMapping("sourceJsonPath",
                        new PostgresJsonField("field2", JsonType.STRING)).hashCode());
    }
}
