/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresJsonField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.postgresql.reporting.model.paths.PostgresTerminalPathSegment;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.TriggerInsertSqlBuilder;
import org.kie.kogito.persistence.reporting.model.paths.JoinPathSegment;
import org.kie.kogito.persistence.reporting.model.paths.PathSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PostgresTriggerInsertSqlBuilder
implements TriggerInsertSqlBuilder<JsonType, PostgresField, PostgresPartitionField, PostgresJsonField, PostgresMapping, PostgresContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresTriggerInsertSqlBuilder.class);
    private static final String CREATE_INSERT_TRIGGER_FUNCTION_TEMPLATE = "CREATE FUNCTION spInsert_%s() RETURNS trigger AS %n$$ %nBEGIN %nINSERT INTO %s %n  SELECT %n%s, %n%s %nRETURN NEW; %nEND; %n$$ LANGUAGE PLPGSQL; %n";
    private static final String CREATE_INSERT_TRIGGER_TEMPLATE = "CREATE TRIGGER trgInsert_%s AFTER INSERT OR UPDATE ON %s %nFOR EACH ROW %n%sEXECUTE PROCEDURE spInsert_%s();%n";
    private static final String CREATE_INSERT_TRIGGER_WHEN_TEMPLATE = "WHEN %n  ( %n %s %n  ) %n";
    private static final String DROP_INSERT_TRIGGER_FUNCTION_TEMPLATE = "DROP FUNCTION IF EXISTS spInsert_%s; %n";
    private static final String DROP_INSERT_TRIGGER_TEMPLATE = "DROP TRIGGER IF EXISTS trgInsert_%s ON %s; %n";
    private static final String TRIGGER_PATH_SEGMENT_TEMPLATE = "'%s'";
    private static final String INSERT_TRIGGER_FUNCTION_FIELD_TEMPLATE = "  (%s)\\:\\:%s as %s";
    private static final String INSERT_TRIGGER_FUNCTION_FROM_TEMPLATE = "  jsonb_array_elements(%n    case jsonb_typeof(%s->'%s') %n      when 'array' then %s->'%s' %n      else jsonb_build_array(%s->'%s')%n    end%n  ) %s";

    public String createInsertTriggerFunctionSql(PostgresContext context) {
        StringBuilder fieldsSql = new StringBuilder();
        String mappingId = context.getMappingId();
        String sourceTableJsonFieldName = context.getSourceTableJsonFieldName();
        String targetTableName = context.getTargetTableName();
        List mappingPaths = context.getMappingPaths();
        ArrayList simpleMappings = new ArrayList();
        simpleMappings.addAll(context.getSourceTableIdentityFields());
        simpleMappings.addAll(context.getSourceTablePartitionFields().stream().map(pf -> new PostgresField(pf.getFieldName())).collect(Collectors.toList()));
        ArrayList fields = new ArrayList();
        PostgresTriggerInsertSqlBuilder.walkMappingPathSegmentsForTerminals(mappingPaths, fields::add);
        if (!fields.isEmpty()) {
            fieldsSql.append(fields.stream().map(f -> PostgresTriggerInsertSqlBuilder.buildTargetFieldMappingSql(f, sourceTableJsonFieldName)).collect(Collectors.joining(", " + String.format("%n", new Object[0]))));
        }
        ArrayList from = new ArrayList();
        for (PathSegment mappingPath : mappingPaths) {
            PostgresTriggerInsertSqlBuilder.walkMappingPathSegmentsForJoins(mappingPath, from::add);
        }
        if (from.isEmpty()) {
            fieldsSql.append(";");
        } else {
            fieldsSql.append(String.format("%n  FROM %n%s;", from.stream().map(f -> PostgresTriggerInsertSqlBuilder.buildJoinSql(f, sourceTableJsonFieldName)).collect(Collectors.joining(", " + String.format("%n", new Object[0])))));
        }
        StringBuilder sql = new StringBuilder();
        sql.append(String.format(CREATE_INSERT_TRIGGER_FUNCTION_TEMPLATE, mappingId, targetTableName, simpleMappings.stream().map(PostgresTriggerInsertSqlBuilder::buildTargetIdentityFieldSql).collect(Collectors.joining(", " + String.format("%n", new Object[0]))), fieldsSql));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Create INSERT TRIGGER FUNCTION SQL:%n%s", sql));
        }
        return sql.toString();
    }

    public String createInsertTriggerSql(PostgresContext context) {
        String mappingId = context.getMappingId();
        String sourceTableName = context.getSourceTableName();
        List sourceTablePartitionFields = context.getSourceTablePartitionFields();
        String sql = String.format(CREATE_INSERT_TRIGGER_TEMPLATE, mappingId, sourceTableName, PostgresTriggerInsertSqlBuilder.buildTargetPartitionFieldsSql(sourceTablePartitionFields), mappingId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Create INSERT TRIGGER SQL:%n%s", sql));
        }
        return sql;
    }

    public String dropInsertTriggerFunctionSql(PostgresContext context) {
        String mappingId = context.getMappingId();
        String sql = String.format(DROP_INSERT_TRIGGER_FUNCTION_TEMPLATE, mappingId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Drop INSERT TRIGGER FUNCTION SQL:%n%s", sql));
        }
        return sql;
    }

    public String dropInsertTriggerSql(PostgresContext context) {
        String mappingId = context.getMappingId();
        String sourceTableName = context.getSourceTableName();
        String sql = String.format(DROP_INSERT_TRIGGER_TEMPLATE, mappingId, sourceTableName);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Drop INSERT TRIGGER SQL:%n%s", sql));
        }
        return sql;
    }

    private static void walkMappingPathSegmentsForTerminals(Collection<PathSegment> paths, Consumer<PostgresTerminalPathSegment> consumer) {
        paths.forEach(path -> {
            if (path instanceof PostgresTerminalPathSegment) {
                consumer.accept((PostgresTerminalPathSegment)((Object)path));
            }
            PostgresTriggerInsertSqlBuilder.walkMappingPathSegmentsForTerminals(path.getChildren(), consumer);
        });
    }

    private static void walkMappingPathSegmentsForJoins(PathSegment path, Consumer<JoinPathSegment> consumer) {
        if (path instanceof JoinPathSegment) {
            consumer.accept((JoinPathSegment)path);
        }
        path.getChildren().forEach(child -> PostgresTriggerInsertSqlBuilder.walkMappingPathSegmentsForJoins(child, consumer));
    }

    private static String buildTargetFieldMappingSql(PostgresTerminalPathSegment terminalSegment, String sourceTableJsonFieldName) {
        PostgresMapping targetField = (PostgresMapping)terminalSegment.getMapping();
        String segmentPathToJoin = PostgresTriggerInsertSqlBuilder.getSegmentPathToJoin(terminalSegment, sourceTableJsonFieldName);
        return String.format(INSERT_TRIGGER_FUNCTION_FIELD_TEMPLATE, segmentPathToJoin, ((JsonType)((Object)((PostgresJsonField)targetField.getTargetField()).getFieldType())).getPostgresType(), ((PostgresJsonField)targetField.getTargetField()).getFieldName());
    }

    private static String buildJoinSql(JoinPathSegment join, String sourceTableJsonFieldName) {
        String parentGroupName = PostgresTriggerInsertSqlBuilder.getParentGroupName((PathSegment)join, sourceTableJsonFieldName);
        String sanitizedSegment = join.getSegment().replace("[]", "");
        return String.format(INSERT_TRIGGER_FUNCTION_FROM_TEMPLATE, parentGroupName, sanitizedSegment, parentGroupName, sanitizedSegment, parentGroupName, sanitizedSegment, join.getGroupName());
    }

    private static String getParentGroupName(PathSegment segment, String sourceTableJsonFieldName) {
        String parentGroupName = String.format("NEW.%s", sourceTableJsonFieldName);
        PathSegment parent = segment.getParent();
        while (Objects.nonNull(parent)) {
            if (parent instanceof JoinPathSegment) {
                parentGroupName = ((JoinPathSegment)parent).getGroupName();
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentGroupName;
    }

    private static String getSegmentPathToJoin(PostgresTerminalPathSegment segment, String sourceTableJsonFieldName) {
        ArrayList<String> segmentsToJoin = new ArrayList<String>();
        String parentGroupName = PostgresTriggerInsertSqlBuilder.getParentGroupName((PathSegment)segment, sourceTableJsonFieldName);
        PostgresTerminalPathSegment current = segment;
        while (Objects.nonNull((Object)current)) {
            String sanitizedSegment = current.getSegment().replace("[]", "");
            if (current instanceof JoinPathSegment) {
                current = null;
                continue;
            }
            segmentsToJoin.add(0, String.format(TRIGGER_PATH_SEGMENT_TEMPLATE, sanitizedSegment));
            current = current.getParent();
        }
        segmentsToJoin.add(0, parentGroupName);
        if (Objects.equals(((PostgresJsonField)((PostgresMapping)segment.getMapping()).getTargetField()).getFieldType(), (Object)JsonType.STRING)) {
            StringBuilder sb = new StringBuilder();
            int segmentsToJoinCount = segmentsToJoin.size() - 1;
            for (int idx = 0; idx < segmentsToJoinCount; ++idx) {
                sb.append((String)segmentsToJoin.get(idx)).append(idx < segmentsToJoinCount - 1 ? "->" : "->>");
            }
            sb.append((String)segmentsToJoin.get(segmentsToJoinCount));
            return sb.toString();
        }
        return String.join((CharSequence)"->", segmentsToJoin);
    }

    private static String buildTargetIdentityFieldSql(PostgresField sourceIdentifyField) {
        return String.format("  NEW.%s", sourceIdentifyField.getFieldName());
    }

    private static String buildTargetPartitionFieldsSql(List<PostgresPartitionField> sourcePartitionFields) {
        if (sourcePartitionFields.isEmpty()) {
            return "";
        }
        return String.format(CREATE_INSERT_TRIGGER_WHEN_TEMPLATE, sourcePartitionFields.stream().map(PostgresTriggerInsertSqlBuilder::buildTargetPartitionFieldSql).collect(Collectors.joining(" AND " + String.format("%n", new Object[0]))));
    }

    private static String buildTargetPartitionFieldSql(PostgresPartitionField sourcePartitionField) {
        return String.format("    NEW.%s = '%s' ", sourcePartitionField.getFieldName(), sourcePartitionField.getFieldValue());
    }
}

