/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.TriggerDeleteSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PostgresTriggerDeleteSqlBuilder
implements TriggerDeleteSqlBuilder<JsonType, PostgresField, PostgresPartitionField, PostgresMapping, PostgresContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresTriggerDeleteSqlBuilder.class);
    private static final String CREATE_DELETE_TRIGGER_FUNCTION_TEMPLATE = "CREATE FUNCTION spDelete_%s() RETURNS trigger AS %n$$ %nBEGIN %nDELETE FROM %s %n  WHERE %n%s; %nRETURN %s; %nEND; %n$$ LANGUAGE PLPGSQL; %n";
    private static final String CREATE_DELETE_TRIGGER_TEMPLATE_FOR_DELETES = "CREATE TRIGGER trgDelete_%s AFTER DELETE ON %s %nFOR EACH ROW %n%sEXECUTE PROCEDURE spDelete_%s();%n";
    private static final String CREATE_DELETE_TRIGGER_TEMPLATE_FOR_UPDATES = "CREATE TRIGGER trgDelete_%s BEFORE UPDATE ON %s %nFOR EACH ROW %n%sEXECUTE PROCEDURE spDelete_%s();%n";
    private static final String CREATE_DELETE_TRIGGER_WHEN_TEMPLATE = "WHEN %n  ( %n %s %n  ) %n";
    private static final String DROP_DELETE_TRIGGER_FUNCTION_TEMPLATE = "DROP FUNCTION IF EXISTS spDelete_%s; %n";
    private static final String DROP_DELETE_TRIGGER_TEMPLATE = "DROP TRIGGER IF EXISTS trgDelete_%s ON %s; %n";

    public String createDeleteTriggerFunctionSql(PostgresContext context) {
        String mappingId = context.getMappingId();
        String targetTableName = context.getTargetTableName();
        ArrayList<PostgresField> simpleMappings = new ArrayList<PostgresField>();
        simpleMappings.addAll(context.getSourceTableIdentityFields());
        simpleMappings.addAll(context.getSourceTablePartitionFields().stream().map(pf -> new PostgresField(pf.getFieldName(), (JsonType)((Object)((Object)pf.getFieldType())))).collect(Collectors.toList()));
        StringBuilder sql = new StringBuilder();
        sql.append(this.createDeleteTriggerFunctionSql(mappingId, "DELETES", targetTableName, simpleMappings, PseudoTable.OLD));
        sql.append(this.createDeleteTriggerFunctionSql(mappingId, "UPDATES", targetTableName, simpleMappings, PseudoTable.NEW));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Create DELETE TRIGGER FUNCTION SQL:%n%s", sql));
        }
        return sql.toString();
    }

    private String createDeleteTriggerFunctionSql(String mappingId, String suffix, String targetTableName, List<PostgresField> simpleMappings, PseudoTable type) {
        return String.format(CREATE_DELETE_TRIGGER_FUNCTION_TEMPLATE, String.format("%s_%s", mappingId, suffix), targetTableName, simpleMappings.stream().map(m -> PostgresTriggerDeleteSqlBuilder.buildTargetIdentityFieldSql(type, m)).collect(Collectors.joining(" AND " + String.format("%n", new Object[0]))), type.name());
    }

    public String createDeleteTriggerSql(PostgresContext context) {
        String mappingId = context.getMappingId();
        String sourceTableName = context.getSourceTableName();
        List sourceTablePartitionFields = context.getSourceTablePartitionFields();
        StringBuilder sql = new StringBuilder();
        sql.append(this.createDeleteTriggerSql(CREATE_DELETE_TRIGGER_TEMPLATE_FOR_DELETES, mappingId, "DELETES", sourceTableName, sourceTablePartitionFields, PseudoTable.OLD));
        sql.append(this.createDeleteTriggerSql(CREATE_DELETE_TRIGGER_TEMPLATE_FOR_UPDATES, mappingId, "UPDATES", sourceTableName, sourceTablePartitionFields, PseudoTable.NEW));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Create DELETE TRIGGER SQL:%n%s", sql));
        }
        return sql.toString();
    }

    private String createDeleteTriggerSql(String template, String mappingId, String suffix, String sourceTableName, List<PostgresPartitionField> sourceTablePartitionFields, PseudoTable type) {
        return String.format(template, String.format("%s_%s", mappingId, suffix), sourceTableName, PostgresTriggerDeleteSqlBuilder.buildTargetPartitionFieldsSql(type, sourceTablePartitionFields), String.format("%s_%s", mappingId, suffix));
    }

    public String dropDeleteTriggerFunctionSql(PostgresContext context) {
        String mappingId = context.getMappingId();
        StringBuilder sql = new StringBuilder();
        sql.append(String.format(DROP_DELETE_TRIGGER_FUNCTION_TEMPLATE, mappingId + "_DELETES"));
        sql.append(String.format(DROP_DELETE_TRIGGER_FUNCTION_TEMPLATE, mappingId + "_UPDATES"));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Drop DELETE TRIGGER FUNCTION SQL:%n%s", sql));
        }
        return sql.toString();
    }

    public String dropDeleteTriggerSql(PostgresContext context) {
        String mappingId = context.getMappingId();
        String sourceTableName = context.getSourceTableName();
        StringBuilder sql = new StringBuilder();
        sql.append(String.format(DROP_DELETE_TRIGGER_TEMPLATE, mappingId + "_DELETES", sourceTableName));
        sql.append(String.format(DROP_DELETE_TRIGGER_TEMPLATE, mappingId + "_UPDATES", sourceTableName));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Drop DELETE TRIGGER SQL:%n%s", sql));
        }
        return sql.toString();
    }

    private static String buildTargetIdentityFieldSql(PseudoTable type, PostgresField sourceIdentifyField) {
        return String.format("  %s = %s.%s", sourceIdentifyField.getFieldName(), type.name(), sourceIdentifyField.getFieldName());
    }

    private static String buildTargetPartitionFieldsSql(PseudoTable type, List<PostgresPartitionField> sourcePartitionFields) {
        if (sourcePartitionFields.isEmpty()) {
            return "";
        }
        return String.format(CREATE_DELETE_TRIGGER_WHEN_TEMPLATE, sourcePartitionFields.stream().map(p -> PostgresTriggerDeleteSqlBuilder.buildTargetPartitionFieldSql(type, p)).collect(Collectors.joining(" AND " + String.format("%n", new Object[0]))));
    }

    private static String buildTargetPartitionFieldSql(PseudoTable type, PostgresPartitionField sourcePartitionField) {
        return String.format("    %s.%s = '%s' ", type.name(), sourcePartitionField.getFieldName(), sourcePartitionField.getFieldValue());
    }

    private static enum PseudoTable {
        OLD,
        NEW;

    }
}

