/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.TableSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PostgresTableSqlBuilder
implements TableSqlBuilder<JsonType, PostgresField, PostgresPartitionField, PostgresMapping, PostgresContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresTableSqlBuilder.class);
    private static final String CREATE_TABLE_TEMPLATE = "CREATE TABLE %s ( %n%s, %n%s %n);%n";
    private static final String DROP_TABLE_TEMPLATE = "DROP TABLE IF EXISTS %s;%n";

    public String createTableSql(PostgresContext context) {
        String targetTableName = context.getTargetTableName();
        List getFieldMappings = context.getFieldMappings();
        ArrayList simpleMappings = new ArrayList();
        simpleMappings.addAll(context.getSourceTableIdentityFields());
        simpleMappings.addAll(context.getSourceTablePartitionFields().stream().map(pf -> new PostgresField(pf.getFieldName(), (JsonType)((Object)((Object)pf.getFieldType())))).collect(Collectors.toList()));
        String sql = String.format(CREATE_TABLE_TEMPLATE, targetTableName, simpleMappings.stream().map(PostgresTableSqlBuilder::buildTargetIdentityFieldSql).collect(Collectors.joining(", " + String.format("%n", new Object[0]))), getFieldMappings.stream().map(PostgresTableSqlBuilder::buildTargetFieldSql).collect(Collectors.joining(", " + String.format("%n", new Object[0]))));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Create TABLE SQL:%n%s", sql));
        }
        return sql;
    }

    public String dropTableSql(PostgresContext context) {
        String targetTableName = context.getTargetTableName();
        String sql = String.format(DROP_TABLE_TEMPLATE, targetTableName);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Drop TABLE SQL:%n%s", sql));
        }
        return sql;
    }

    private static String buildTargetIdentityFieldSql(PostgresField sourceIdentifyField) {
        return String.format("  %s %s", sourceIdentifyField.getFieldName(), ((JsonType)((Object)sourceIdentifyField.getFieldType())).getPostgresType());
    }

    private static String buildTargetFieldSql(PostgresMapping targetField) {
        return String.format("  %s %s", ((PostgresField)targetField.getTargetField()).getFieldName(), ((JsonType)((Object)((PostgresField)targetField.getTargetField()).getFieldType())).getPostgresType());
    }
}

